set foreign_key_checks=0;

ALTER TABLE `admission` ADD COLUMN `applicationId` BIGINT NOT NULL AFTER `id`, 
ADD COLUMN `application_program_id` BIGINT NULL AFTER `applicationId`,
 CHANGE `studentId` `studentId` BIGINT(20) NULL,
 CHANGE `code` `code` VARCHAR(20) NULL, 
 ADD COLUMN `status` VARCHAR(50) NOT NULL AFTER `code`,
 ADD COLUMN `admissionDate` TIMESTAMP NULL AFTER `status`,
 ADD COLUMN `admission_type` VARCHAR(100) NULL AFTER `admissionDate`, 
 ADD COLUMN `receiptId` VARCHAR(50) NULL AFTER `admission_type`, 
 ADD COLUMN `trial_start_date` TIMESTAMP NULL AFTER `receiptId`, 
 ADD COLUMN `trial_end_date` TIMESTAMP NOT NULL AFTER `trial_start_date`,
 ADD COLUMN `provisional_last_date` TIMESTAMP NULL AFTER `trial_end_date`,
 ADD COLUMN `Confirmed_admission_closure_reason` VARCHAR(255) NULL AFTER `provisional_last_date`,
 ADD COLUMN `trial_admission_closure_reason` VARCHAR(255) NULL AFTER `Confirmed_admission_closure_reason`, 
 ADD COLUMN `provisional_admission_closure_reason` VARCHAR(255) NULL AFTER `trial_admission_closure_reason`,
 ADD COLUMN `advisior_id` BIGINT NULL AFTER `provisional_admission_closure_reason`,
 ADD COLUMN `whetherWithdrawl` BOOLEAN NULL AFTER `advisior_id`,
 ADD COLUMN `whetherDenied` BOOLEAN NULL AFTER `whetherWithdrawl`,
 ADD COLUMN `whetherConfirmed` BOOLEAN NULL AFTER `whetherDenied`; 
 
ALTER TABLE `admission`
ADD CONSTRAINT `refApplication` FOREIGN KEY (`applicationId`) REFERENCES `application`(`id`),
ADD CONSTRAINT `refApplicationProg` FOREIGN KEY (`application_program_id`) REFERENCES `application_program`(`id`),
ADD CONSTRAINT `refuser_advisor` FOREIGN KEY (`advisior_id`) REFERENCES `users`(`id`); 

 
ALTER TABLE `app_extra_curricular` DROP FOREIGN KEY `Refapplicant2012`; 
ALTER TABLE `app_extra_curricular` ADD CONSTRAINT `Refapplicant2012` FOREIGN KEY (`applicantId`) REFERENCES `application`(`id`); 
DROP TABLE `applicant_cf_data`;
DROP TABLE `applicant_prev_exam`;
DROP TABLE `applicant`; 
DROP TABLE `application_fee_payment`; 
DROP TABLE `application_status`; 
DROP TABLE `application_program_status`;

ALTER TABLE `application_program`
ADD COLUMN `whetherHostelApplicable` BOOLEAN NULL AFTER `feeAmount`,
ADD COLUMN `whetherTransportApplicable` BOOLEAN NULL AFTER `whetherHostelApplicable`,
ADD COLUMN `distancetoTravel` INT NULL AFTER `whetherTransportApplicable`, 
ADD COLUMN `aproval_reason_id` BIGINT NULL AFTER `distancetoTravel`,
ADD COLUMN `rejection_reason_id` BIGINT NULL AFTER `aproval_reason_id`, 
ADD COLUMN `withdrawl_reason_id` BIGINT NULL AFTER `rejection_reason_id`, 
ADD COLUMN `aproval_remark` VARCHAR(255) NULL AFTER `withdrawl_reason_id`,
ADD COLUMN `rejection_remark` VARCHAR(255) NULL AFTER `aproval_remark`, 
ADD COLUMN `withdrawl_remark` VARCHAR(255) NULL AFTER `rejection_remark`; 

set foreign_key_checks=1;