CREATE TABLE `vechicle` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vehicleCode` varchar(45) DEFAULT NULL,
  `vehicleNumber` varchar(60) DEFAULT NULL,
  `model` varchar(45) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  `capacity` int(11) DEFAULT NULL,
  `whetherRouteApplicable` bit(1) DEFAULT NULL,
  `purchaseFrom` varchar(255) DEFAULT NULL,
  `purchaseFromAddressId` bigint(20) DEFAULT NULL,
  `serviceBy` varchar(255) DEFAULT NULL,
  `serviceByAddressId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refvechicleresource_idx` (`resourceId`),
  KEY `Refserviceaddress_idx` (`serviceByAddressId`),
  KEY `Refpurchesaddress_idx` (`purchaseFromAddressId`),
  KEY `Refvechicleupdatedby_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refpurchesaddress` FOREIGN KEY (`purchaseFromAddressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refserviceaddress` FOREIGN KEY (`serviceByAddressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refvechicleresource` FOREIGN KEY (`resourceId`) REFERENCES `resources` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refvechicleupdatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vehicle_emission_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vechicleId` bigint(20) NOT NULL,
  `emissionVendor` varchar(100) DEFAULT NULL,
  `emissionVendorAddressId` bigint(20) DEFAULT NULL,
  `emissionCheckOn` date DEFAULT NULL,
  `emissionToBeCheckOn` date DEFAULT NULL,
  `emissionPolicyWith` varchar(100) DEFAULT NULL,
  `emissionCurrencyId` bigint(20) DEFAULT NULL,
  `emissionCost` double(10,2) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefVehicleId231_idx` (`vechicleId`),
  KEY `Refemissionaddress_idx` (`emissionVendorAddressId`),
  KEY `Refemissioncurrency_idx` (`emissionCurrencyId`),
  KEY `Refemissionupdatedby_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refemissionaddress` FOREIGN KEY (`emissionVendorAddressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refemissioncurrency` FOREIGN KEY (`emissionCurrencyId`) REFERENCES `currency` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refemissionupdatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefVehicleId231` FOREIGN KEY (`vechicleId`) REFERENCES `vechicle` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vehicle_emission_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vehicleEmissionId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refvehicleemission_idx` (`vehicleEmissionId`),
  KEY `Refemissiondocument_idx` (`documentId`),
  KEY `Refemissiondocupby_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refemissiondocupby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refemissiondocument` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refvehicleemission` FOREIGN KEY (`vehicleEmissionId`) REFERENCES `vehicle_emission_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vehicle_insurance_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vechicleId` bigint(20) NOT NULL,
  `insuranceVendor` varchar(100) DEFAULT NULL,
  `insuranceVendorAddressId` bigint(20) DEFAULT NULL,
  `validFrom` date DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `policyNumber` varchar(255) DEFAULT NULL,
  `insurancePolicyWith` varchar(100) DEFAULT NULL,
  `insuranceCurrencyId` bigint(20) DEFAULT NULL,
  `insuranceCost` double(10,2) DEFAULT NULL,
  `insurancePaidOn` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refvechicle1001_idx` (`vechicleId`),
  KEY `Refinsuranceaddress_idx` (`insuranceVendorAddressId`),
  KEY `Refinsuranceupdatedby_idx` (`lastUpdatedBy`),
  KEY `Refinsurancecurrency_idx` (`insuranceCurrencyId`),
  CONSTRAINT `Refinsuranceaddress` FOREIGN KEY (`insuranceVendorAddressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refinsurancecurrency` FOREIGN KEY (`insuranceCurrencyId`) REFERENCES `currency` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refinsuranceupdatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refvechicle1001` FOREIGN KEY (`vechicleId`) REFERENCES `vechicle` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vehicle_insurance_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vehicleInsuranceId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefvehicleInsurance_idx` (`vehicleInsuranceId`),
  KEY `Refinsurencedoucment_idx` (`documentId`),
  KEY `Refdoucmentupdatedby_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refdoucmentupdatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refinsurencedoucment` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefvehicleInsurance` FOREIGN KEY (`vehicleInsuranceId`) REFERENCES `vehicle_insurance_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vehicle_road_tax_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vechicleId` bigint(20) NOT NULL,
  `roadTaxVendor` varchar(100) DEFAULT NULL,
  `roadTaxVendorAddressId` bigint(20) DEFAULT NULL,
  `validFrom` date DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `referenceNumber` varchar(100) DEFAULT NULL,
  `roadTaxWith` varchar(100) DEFAULT NULL,
  `roadTaxCurrency` bigint(20) DEFAULT NULL,
  `roadTaxCost` double(10,2) DEFAULT NULL,
  `roadTaxPaidOn` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refvehicleid1102_idx` (`vechicleId`),
  KEY `Refroadtaxvendoradd_idx` (`roadTaxVendorAddressId`),
  KEY `Refroadtaxcurrency_idx` (`roadTaxCurrency`),
  KEY `Refroadtaxupdatedby_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refroadtaxcurrency` FOREIGN KEY (`roadTaxCurrency`) REFERENCES `currency` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refroadtaxupdatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refroadtaxvendoradd` FOREIGN KEY (`roadTaxVendorAddressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refvehicleid1102` FOREIGN KEY (`vechicleId`) REFERENCES `vechicle` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vehicle_road_tax_document` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vehicleRoadTaxId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`Id`),
  KEY `Refroadtaxref_idx` (`vehicleRoadTaxId`),
  KEY `Refroadtaxdoucmet_idx` (`documentId`),
  KEY `Refroadtaxupdatedby_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refroadtaxdoucmet` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refroadtaxref` FOREIGN KEY (`vehicleRoadTaxId`) REFERENCES `vehicle_road_tax_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refuserroadtaxupda` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
