-- Applicant Education History Custom Data

-- Dropping Older table
DROP TABLE IF EXISTS `applicant_education_history_cf_data`;

-- Safe Guard Drop statement for newer table
DROP TABLE IF EXISTS `applicant_education_histories_cd`;

-- Create statement for the new table
CREATE TABLE `applicant_education_histories_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantEducationHistoryId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  CONSTRAINT `ref_applicant_education_histories_cd_aeh_id` FOREIGN KEY (`applicantEducationHistoryId`) REFERENCES `applicant_education_histories` (`id`),
  CONSTRAINT `ref_applicant_education_histories_cd_users_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


-- Applicant person Custom Data

-- Dropping Older table
DROP TABLE IF EXISTS `applicant_person_cf_data`;

-- Safe Guard Drop statement for newer table
DROP TABLE IF EXISTS `applicant_person_cd`;

-- Create statement for the new table
CREATE TABLE `applicant_person_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  CONSTRAINT `ref_applicant_person_cd_ap_id` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT `ref_applicant_person_cd_users_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Enquiry Custom Data
DROP TABLE IF EXISTS `enquiry_cf_data`;

-- Safe Guard Drop statement for newer table
DROP TABLE IF EXISTS `enquiry_cd`;

-- Create statement for the new table
CREATE TABLE `enquiry_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `enquiryId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  CONSTRAINT `ref_enquiry_cd_enquiry_id` FOREIGN KEY (`enquiryId`) REFERENCES `enquiry` (`id`),
  CONSTRAINT `ref_enquiry_cd_users_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- Campaign
-- Droping Old table
DROP TABLE IF EXISTS `campaign_cf_data` ;

-- Safe Guard Drop of New Named Table
DROP TABLE IF EXISTS `campaign_cd` ;

-- Create Statement for Campaign
CREATE TABLE `campaign_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `campaignId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `Ref_campaign_cd_users_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Ref_campaign_cd_campaign_id` FOREIGN KEY (`campaignId`) REFERENCES `campaign` (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- CustomTableConfigs changes
SET SQL_SAFE_UPDATES=0;

update `custom_table_configs` set `customTableName`='applicant_education_history_cd' where tableName='applicant_education_histories';
update `custom_table_configs` set `customTableName`='applicant_person_cd' where tableName='applicant_person';
update `custom_table_configs` set `customTableName`='enquiry_cd' where tableName='enquiry';
update `custom_table_configs` set `customTableName`='campaign_cd' where tableName='campaign';

SET SQL_SAFE_UPDATES=1;