CREATE TABLE `evaluation_student_remark` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT(20) NULL DEFAULT NULL,
  `evalSequenceId` BIGINT(20) NULL DEFAULT NULL,
  `evalPlanLevelTwoId` BIGINT(20) NULL,
  `evalPlanLevelOneId` BIGINT(20) NULL DEFAULT NULL,
  `remark` VARCHAR(512) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_evaluation_student_remark_evalSequenceId0_idx` (`evalSequenceId` ASC),
  INDEX `fk_evaluation_student_remark_LevelTwoId_idx` (`evalPlanLevelTwoId` ASC),
  INDEX `fk_evaluation_student_remark_LevelOneId_idx` (`evalPlanLevelOneId` ASC),
  INDEX `fk_evaluation_student_remark_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_evaluation_student_remark_admissionId_idx` (`admissionId` ASC),
  CONSTRAINT `fk_evaluation_student_remark_evalSequenceId0`
    FOREIGN KEY (`evalSequenceId`)
    REFERENCES `evaluation_sequence` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_evaluation_student_remark_LevelTwoId`
    FOREIGN KEY (`evalPlanLevelTwoId`)
    REFERENCES `evaluation_plan_level_two` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_evaluation_student_remark_LevelOneId`
    FOREIGN KEY (`evalPlanLevelOneId`)
    REFERENCES `evaluation_plan_level_one` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_evaluation_student_remark_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_evaluation_student_remark_admissionId`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
