CREATE TABLE `survey_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `surveyId` bigint(20) DEFAULT NULL,
  `surveyTitle` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `completedResponses` int(11) DEFAULT NULL,
  `incompleteResponses` int(11) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `surveySetupConfigurationId` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `FK8A2966E7ED259864` (`lastUpdatedBy`),
  KEY `FK8A2966E7A92768DE` (`surveySetupConfigurationId`),
  KEY `FK8A2966E7EF51A200` (`academyLocationId`),
  CONSTRAINT `FK8A2966E7A92768DE` FOREIGN KEY (`surveySetupConfigurationId`) REFERENCES `survey_setup_configuration` (`id`),
  CONSTRAINT `FK8A2966E7ED259864` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `FK8A2966E7EF51A200` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `survey_participant_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userId` bigint(20) DEFAULT NULL,
  `surveyUrl` varchar(255) DEFAULT NULL,
  `surveyMasterId` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `FK3F64D07F45ECC5D0` (`surveyMasterId`),
  KEY `FK3F64D07FED259864` (`lastUpdatedBy`),
  CONSTRAINT `FK3F64D07F45ECC5D0` FOREIGN KEY (`surveyMasterId`) REFERENCES `survey_master` (`id`),
  CONSTRAINT `FK3F64D07FED259864` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
