SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `survey_setup_configuration`;

CREATE TABLE `survey_setup_configuration`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`academyLocationId` BIGINT(20), 
	`hostURL` VARCHAR(255),
	`apiURL` VARCHAR(255),
	 `isDefault` BIT(1),
	 `isActive` BIT(1),
	 `userName` VARCHAR(255),
	 `password` VARCHAR(255),
	 `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	 `lastUpdatedBy` BIGINT(20),
	  PRIMARY KEY (`id`), 
	  CONSTRAINT `survey_setup_configuration_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`), 
	  CONSTRAINT `survey_setup_configuration_academyLocationId_FK` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`) ) ENGINE=INNODB DEFAULT 

CHARSET=utf8; 


SET @standardMasterMaxId =(SELECT id FROM standard_master WHERE tableName = 'survey_setup_configuration');
SELECT @standardMasterMaxId;

DELETE FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId;

INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, 

`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId, 'Varchar', '1', 1, 'academy_location', 'id','academyLocationName', 0, 0, 0, '1', SYSDATE()),
('hostURL', 'HOST_URL', @standardMasterMaxId, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('apiURL', 'API_URL', @standardMasterMaxId, 'Varchar', '3', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('isDefault','IS_DEFAULT',@standardMasterMaxId,'Boolean','4',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('isActive','IS_ACTIVE',@standardMasterMaxId,'Boolean','5',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('userName','USERNAME',@standardMasterMaxId,'Varchar','6',0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('password','PASSWORD',@standardMasterMaxId,'Varchar','6',0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE());
SET FOREIGN_KEY_CHECKS=1;