
CREATE TABLE `moodle_course` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `moodleCourseId` bigint(20) DEFAULT NULL,
  `academiaCourseVariantId` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `FKB912908AB21BDF6D` (`academiaCourseVariantId`),
  KEY `FKB912908AED259864` (`lastUpdatedBy`),
  KEY `FKB912908AEF51A200` (`academyLocationId`),
  CONSTRAINT `FKB912908AB21BDF6D` FOREIGN KEY (`academiaCourseVariantId`) REFERENCES `course_variants` (`id`),
  CONSTRAINT `FKB912908AED259864` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `FKB912908AEF51A200` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

CREATE TABLE `moodle_course_mapping` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academiaStudentId` bigint(20) DEFAULT NULL,
  `mappingId` bigint(20) DEFAULT NULL,
  `moodleCourseId` bigint(20) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `FKB0E2261975F6172E` (`moodleCourseId`),
  KEY `FKB0E22619ED259864` (`lastUpdatedBy`),
  CONSTRAINT `FKB0E2261975F6172E` FOREIGN KEY (`moodleCourseId`) REFERENCES `moodle_course` (`id`),
  CONSTRAINT `FKB0E22619ED259864` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8;



