
ALTER TABLE `examination_result` 
DROP INDEX  `exam_result_unique_record1`,
ADD UNIQUE INDEX `exam_result_unique_record1` (`admissionId` ASC, `evaluationDetailSequenceId` ASC, `sectionId` ASC, `courseVariantId` ASC);



ALTER TABLE `evaluation_sequence_rank` 
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `admissionId`,
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
CHANGE COLUMN `marksObtainedFrom` `marksObtainedFrom` BIGINT(20) NULL DEFAULT NULL,
ADD COLUMN `gradeObtainedFrom` VARCHAR(45) NULL DEFAULT NULL AFTER `marksObtainedFrom`,
ADD INDEX `fk_evaluation_sequence_rank_1_idx` (`sectionId` ASC),
ADD INDEX `fk_evaluation_sequence_rank_2_idx` (`courseVariantId` ASC),
DROP INDEX `method_rank_unique_record` ,
ADD UNIQUE INDEX `method_rank_unique_record` (`admissionId` ASC, `evaluationSequenceId` ASC, `sectionId` ASC, `courseVariantId` ASC);
ALTER TABLE `evaluation_sequence_rank` 
ADD CONSTRAINT `fk_evaluation_sequence_rank_1`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_evaluation_sequence_rank_2`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;




ALTER TABLE `evaluation_plan_level_two_rank` 
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `admissionId`,
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
CHANGE COLUMN `marksObtainedFrom` `marksObtainedFrom` BIGINT(20) NULL DEFAULT NULL,
ADD COLUMN `gradeObtainedFrom` VARCHAR(45) NULL DEFAULT NULL AFTER `marksObtainedFrom`,
ADD INDEX `fk_evaluation_plan_level_two_rank_1_idx` (`sectionId` ASC),
ADD INDEX `fk_evaluation_plan_level_two_rank_2_idx` (`courseVariantId` ASC),
DROP INDEX `evel_plan_level_two_unique_record` ,
ADD UNIQUE INDEX `evel_plan_level_two_unique_record` (`admissionId` ASC, `evaluationPlanLevelTwoId` ASC, `sectionId` ASC, `courseVariantId` ASC);
ALTER TABLE `evaluation_plan_level_two_rank` 
ADD CONSTRAINT `fk_evaluation_plan_level_two_rank_1`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_evaluation_plan_level_two_rank_2`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;




ALTER TABLE `evaluation_plan_level_one_rank` 
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `admissionId`,
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
CHANGE COLUMN `marksObtainedFrom` `marksObtainedFrom` BIGINT(20) NULL DEFAULT NULL,
ADD COLUMN `gradeObtainedFrom` VARCHAR(45) NULL DEFAULT NULL AFTER `marksObtainedFrom`,
ADD INDEX `fk_evaluation_plan_level_one_rank_1_idx` (`sectionId` ASC),
ADD INDEX `fk_evaluation_plan_level_one_rank_2_idx` (`courseVariantId` ASC),
DROP INDEX `evel_plan_level_one_unique_record` ,
ADD UNIQUE INDEX `evel_plan_level_one_unique_record` (`admissionId` ASC, `evaluationPlanLevelOneId` ASC, `sectionId` ASC, `courseVariantId` ASC);
ALTER TABLE `evaluation_plan_level_one_rank` 
ADD CONSTRAINT `fk_evaluation_plan_level_one_rank_1`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_evaluation_plan_level_one_rank_2`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;




ALTER TABLE `evaluation_plan_rank` 
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `admissionId`,
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `sectionId`,
CHANGE COLUMN `marksObtainedFrom` `marksObtainedFrom` BIGINT(20) NULL DEFAULT NULL,
ADD COLUMN `gradeObtainedFrom` VARCHAR(45) NULL DEFAULT NULL AFTER `marksObtainedFrom`,
ADD INDEX `fk_evaluation_plan_rank_1_idx1` (`sectionId` ASC),
ADD INDEX `fk_evaluation_plan_rank_2_idx` (`courseVariantId` ASC),
DROP INDEX `evel_plan_unique_record` ,
ADD UNIQUE INDEX `evel_plan_unique_record` (`admissionId` ASC, `evaluationPlanId` ASC, `sectionId` ASC, `courseVariantId` ASC);
ALTER TABLE `evaluation_plan_rank` 
ADD CONSTRAINT `fk_evaluation_plan_rank_1`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_evaluation_plan_rank_2`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
