set sql_safe_updates = 0;
delete dup 
from 
users_system_usage_log initial INNER JOIN users_system_usage_log dup
ON initial.userId = dup.userId
and initial.featurePrivilegeId = dup.featurePrivilegeId
and initial.id < dup.id
and (
(initial.academyLocationId = dup.academyLocationId) or 
(initial.academyLocationId is null and  dup.academyLocationId is null)
)
WHERE
TIME_TO_SEC(TIMEDIFF(dup.accessTime,initial.accessTime)) > -5
and TIME_TO_SEC(TIMEDIFF(dup.accessTime,initial.accessTime)) < 7;
set sql_safe_updates = 1;
