
-- Main Tables

-- for evaluation detention 

ALTER TABLE `evaluation_plan_level_two` 
ADD COLUMN `contributeToDetention` BIT(1) NULL DEFAULT b'0' AFTER `whetherRemark`;

ALTER TABLE `evaluation_sequence` 
ADD COLUMN `contributeToDetention` BIT(1) NULL DEFAULT b'0' AFTER `whetherRemark`;

-- for apply detention 

ALTER TABLE `eval_seq_detail` 
ADD COLUMN `contributeToDetention` BIT(1) NULL DEFAULT b'0' AFTER `createdDate`,
ADD COLUMN `whetherDetentionApplicable` BIT(1) NULL DEFAULT b'0' AFTER `contributeToDetention`,
ADD COLUMN `attendanceBasedDetention` BIT(1) NULL DEFAULT b'0' AFTER `whetherDetentionApplicable`,
ADD COLUMN `evaluationBasedDetention` BIT(1) NULL DEFAULT b'0' AFTER `attendanceBasedDetention`,
ADD COLUMN `subTypeLevelEvelDetentionId` BIGINT(20) NULL DEFAULT NULL AFTER `evaluationBasedDetention`,
ADD COLUMN `methodLevelEvelDetentionId` BIGINT(20) NULL DEFAULT NULL AFTER `subTypeLevelEvelDetentionId`,
ADD COLUMN `eventLevelEvelDetentionId` BIGINT(20) NULL DEFAULT NULL AFTER `methodLevelEvelDetentionId`,
ADD INDEX `evalDetentionSubTypeLevel` (`subTypeLevelEvelDetentionId` ASC),
ADD INDEX `evalDetentionMethodLevel` (`methodLevelEvelDetentionId` ASC),
ADD INDEX `evalDetentionEventLevel` (`eventLevelEvelDetentionId` ASC);
ALTER TABLE `eval_seq_detail` 
ADD CONSTRAINT `evalDetentionSubTypeLevel_fk`
  FOREIGN KEY (`subTypeLevelEvelDetentionId`)
  REFERENCES `evaluation_plan_level_two` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `evalDetentionMethodLevel_fk`
  FOREIGN KEY (`methodLevelEvelDetentionId`)
  REFERENCES `evaluation_sequence` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `evalDetentionEventLevel_fk`
  FOREIGN KEY (`eventLevelEvelDetentionId`)
  REFERENCES `eval_seq_detail` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

-- For manage detantion data

 ALTER TABLE `examination_result` 
ADD COLUMN `reasonForNonDetention` VARCHAR(255) NULL DEFAULT NULL AFTER `calculationDone`,
ADD COLUMN `nonDetentionApplicableDate` DATE NULL DEFAULT NULL AFTER `reasonForNonDetention`,
ADD COLUMN `nonDetentionApprovedBy` BIGINT(20) NULL DEFAULT NULL AFTER `nonDetentionApplicableDate`,
ADD COLUMN `nonDetentionRemark` VARCHAR(255) NULL DEFAULT NULL AFTER `nonDetentionApprovedBy`,
ADD INDEX `nonDetentionExamResult` (`nonDetentionApprovedBy` ASC);
ALTER TABLE `examination_result` 
ADD CONSTRAINT `nonDetentionExamResult_fk1`
  FOREIGN KEY (`nonDetentionApprovedBy`)
  REFERENCES `users` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT; 

-- manage detent studnt

ALTER TABLE `exam_result_event_students` 
ADD COLUMN `whetherDetention` BIT(1) NULL DEFAULT b'0' AFTER `sectionId`,
ADD COLUMN `detentionResion` VARCHAR(255) NULL DEFAULT NULL AFTER `whetherDetention`;
  
-- manage detention criteria 
 
CREATE TABLE `exam_detention_criteria` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `criteriaName` VARCHAR(255) NOT NULL,
  `fromPercentage` INT(11) NOT NULL,
  `toPercentage` INT(11) NOT NULL,
  `tillAttendanceDate` DATE NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `exam_detention_criteria00001` (`lastUpdatedBy`),
  CONSTRAINT `exam_detention_criteria00001` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
  
-- manage mapping of event detention
  
CREATE TABLE `exam_detention_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `periodId` bigint(20) NOT NULL,
  `eventId` bigint(20) NOT NULL,
  `courseVariantId` bigint(20) NOT NULL,
  `examDetentionCriteriaId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_detention_events_unique_record1` (`periodId`,`eventId`,`examDetentionCriteriaId`,`courseVariantId`),
  KEY `exam_detention_events001` (`periodId`),
  KEY `exam_detention_events002` (`eventId`),
  KEY `exam_detention_events003` (`courseVariantId`),
  KEY `exam_detention_events004` (`examDetentionCriteriaId`),
  KEY `exam_detention_events005` (`lastUpdatedBy`),
  CONSTRAINT `exam_detention_events001` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `exam_detention_events002` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`),
  CONSTRAINT `exam_detention_events003` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`),
  CONSTRAINT `exam_detention_events004` FOREIGN KEY (`examDetentionCriteriaId`) REFERENCES `exam_detention_criteria` (`id`),
  CONSTRAINT `exam_detention_events005` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
  
  