
CREATE TABLE `hostel_attendance` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `hostelId` bigint(20) NOT NULL,
  `buildinglId` bigint(20) DEFAULT NULL,
  `floorId` bigint(20) NOT NULL,
  `dateOfAttendance` date NOT NULL,
  `fromTime` datetime DEFAULT NULL,
  `toTime` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_attendance_academyLocationId` (`academyLocationId`),
  KEY `fk_hostel_attendance_hostelId` (`hostelId`),
  KEY `fk_hostel_attendance_buildinglId` (`buildinglId`),
  KEY `fk_hostel_attendance_floorId` (`floorId`),
  KEY `fk_hostel_attendance_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_hostel_attendance_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_hostel_attendance_hostelId` FOREIGN KEY (`hostelId`) REFERENCES `hostel` (`id`),
  CONSTRAINT `fk_hostel_attendance_buildinglId` FOREIGN KEY (`buildinglId`) REFERENCES `hostel_building` (`id`),
  CONSTRAINT `fk_hostel_attendance_floorId` FOREIGN KEY (`floorId`) REFERENCES `hostel_floor` (`id`),
  CONSTRAINT `fk_hostel_attendance_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `hostel_attendance_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attendanceId` bigint(20) NOT NULL,
  `userId` bigint(20) NOT NULL,
  `attendanceStatus` varchar(25) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hostel_attendance_detail_attendanceId` (`attendanceId`),
  KEY `hostel_attendance_detail_userId` (`userId`),
  KEY `hostel_attendance_detail_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `hostel_attendance_detail_attendanceId` FOREIGN KEY (`attendanceId`) REFERENCES `hostel_attendance` (`id`),
  CONSTRAINT `hostel_attendance_detail_userId` FOREIGN KEY (`userId`) REFERENCES `users` (`id`),
  CONSTRAINT `hostel_attendance_detail_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
