   CREATE TABLE `employee_development_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `personId` bigint(20) NOT NULL,
  `professionalGoal` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `strategies` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expectedOutcome` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qualities` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `strength` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weakness` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isAchieved` bit(1) DEFAULT NULL,
  `improvementPlan` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `improvementSuggestions` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `version` decimal(10,0) NOT NULL,
  `whetherDeleted` bit(1) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ref_persons_001_idx` (`personId`),
  CONSTRAINT `ref_persons_001` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
  KEY `ref_lastUpdatedBy_002_idx` (`lastUpdatedBy`),
  CONSTRAINT `ref_lastUpdatedBy_002` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




