CREATE TABLE `question_paper_bank_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `questionPaperBankId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_question_paper_bank_documents_documents` (`documentId`),
  KEY `FK_question_paper_bank_documents_QPBID` (`questionPaperBankId`),
  KEY `FK_question_paper_bank_documents_usersId` (`lastUpdatedBy`),
  CONSTRAINT `FK_question_paper_bank_documents_QPBID` FOREIGN KEY (`questionPaperBankId`) REFERENCES `question_paper_bank` (`id`),
  CONSTRAINT `FK_question_paper_bank_documents_usersId` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `FK_question_paper_bank_documents_documents` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;