
DROP PROCEDURE IF EXISTS standardMasterUniqueCheck;

DELIMITER $$
CREATE PROCEDURE standardMasterUniqueCheck()
	BEGIN
create temporary table if not exists templog_standardMasterUniqueCheck (msg varchar(1024));

START TRANSACTION;
   
insert into templog_standardMasterUniqueCheck values('START');

DELETE n1 FROM application_prog_rejection_reasons n1, application_prog_rejection_reasons n2 
WHERE n1.id < n2.id AND n1.code = n2.code;
DELETE n1 FROM application_prog_rejection_reasons n1, application_prog_rejection_reasons n2 
WHERE n1.id < n2.id AND n1.value = n2.value;

update application_prog_rejection_reasons set code = value where code is null;
update application_prog_rejection_reasons set value = code where value is null;
delete from application_prog_rejection_reasons where code is null and value is null;

ALTER TABLE `application_prog_rejection_reasons` 
CHANGE COLUMN `code` `code` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `application_prog_rejection_reasons_code_unique` (`code` ASC),
ADD UNIQUE INDEX `application_prog_rejection_reasons_value_unique` (`value` ASC);

update templog_standardMasterUniqueCheck set msg ='application_prog_rejection_reasons';

DELETE n1 FROM examination_name n1, examination_name n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM examination_name n1, examination_name n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

update examination_name set itemCode = itemValue where itemCode is null;
update examination_name set itemValue = itemCode where itemValue is null;
delete from examination_name where itemCode is null and itemValue is null;

ALTER TABLE `examination_name` 
ADD UNIQUE INDEX `examination_name_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `examination_name_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='examination_name';

DELETE n1 FROM examination_year n1, examination_year n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM examination_year n1, examination_year n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `examination_year` 
ADD UNIQUE INDEX `examination_year_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `examination_year_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='examination_year';

DELETE n1 FROM result_status n1, result_status n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM result_status n1, result_status n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `result_status` 
ADD UNIQUE INDEX `result_status_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `result_status_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='result_status';

DELETE n1 FROM study_mode n1, study_mode n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM study_mode n1, study_mode n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `study_mode` 
ADD UNIQUE INDEX `study_mode_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `study_mode_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='study_mode';

DELETE n1 FROM exam_document_name n1, exam_document_name n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM exam_document_name n1, exam_document_name n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

update exam_document_name set itemCode = itemValue where itemCode is null and itemValue is not null;
update exam_document_name set itemValue = itemCode where itemValue is null and itemCode is not null;
delete from exam_document_name where itemCode is null and itemValue is null;

ALTER TABLE `exam_document_name` 
CHANGE COLUMN `itemCode` `itemCode` VARCHAR(255) NOT NULL ,
CHANGE COLUMN `itemValue` `itemValue` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `exam_document_name_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `exam_document_name_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='exam_document_name';

DELETE n1 FROM exam_malpractice_type n1, exam_malpractice_type n2 
WHERE n1.id < n2.id AND n1.malPracticeType = n2.malPracticeType;

delete from exam_malpractice_type where malPracticeType is null;

ALTER TABLE `exam_malpractice_type` 
CHANGE COLUMN `malPracticeType` `malPracticeType` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `exam_malpractice_type_value_unique` (`malPracticeType` ASC);

update templog_standardMasterUniqueCheck set msg ='exam_malpractice_type';

DELETE n1 FROM non_detention_reason n1, non_detention_reason n2 
WHERE n1.id < n2.id AND n1.reason = n2.reason;

delete from non_detention_reason where reason is null;

ALTER TABLE `non_detention_reason` 
CHANGE COLUMN `reason` `reason` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `non_detention_reason_value_unique` (`reason` ASC);

update templog_standardMasterUniqueCheck set msg ='non_detention_reason';

DELETE n1 FROM evaluation_type n1, evaluation_type n2 
WHERE n1.id < n2.id AND n1.evaluationType = n2.evaluationType;

delete from evaluation_type where evaluationType is null;

ALTER TABLE `evaluation_type` 
CHANGE COLUMN `evaluationType` `evaluationType` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `evaluation_type_value_unique` (`evaluationType` ASC);

update templog_standardMasterUniqueCheck set msg ='evaluation_type';

DELETE n1 FROM evaluation_sub_type n1, evaluation_sub_type n2 
WHERE n1.id < n2.id AND n1.evaluationSubType = n2.evaluationSubType;

delete from evaluation_sub_type where evaluationSubType is null;

ALTER TABLE `evaluation_sub_type` 
CHANGE COLUMN `evaluationSubType` `evaluationSubType` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `evaluation_sub_type_value_unique` (`evaluationSubType` ASC);

update templog_standardMasterUniqueCheck set msg ='evaluation_sub_type';

DELETE n1 FROM evaluation_plan_other_category n1, evaluation_plan_other_category n2 
WHERE n1.id < n2.id AND n1.categoryName = n2.categoryName;

delete from evaluation_plan_other_category where categoryName is null;

ALTER TABLE `evaluation_plan_other_category` 
CHANGE COLUMN `categoryName` `categoryName` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `evaluation_plan_other_category_value_unique` (`categoryName` ASC);

update templog_standardMasterUniqueCheck set msg ='evaluation_plan_other_category';

DELETE n1 FROM evaluation_plan_other_sub_category n1, evaluation_plan_other_sub_category n2 
WHERE n1.id < n2.id AND n1.subCategoryName = n2.subCategoryName and n1.categoryId = n2.categoryId;

delete from evaluation_plan_other_sub_category where subCategoryName is null;

ALTER TABLE `evaluation_plan_other_sub_category` 
CHANGE COLUMN `subCategoryName` `subCategoryName` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `evaluation_plan_other_sub_category_value_unique` (`categoryId` ASC, `subCategoryName` ASC);

update templog_standardMasterUniqueCheck set msg ='evaluation_plan_other_sub_category';


DELETE n1 FROM domicile n1, domicile n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM domicile n1, domicile n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `domicile` 
ADD UNIQUE INDEX `domicile_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `domicile_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='domicile';

DELETE n1 FROM identity_type n1, identity_type n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM identity_type n1, identity_type n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `identity_type` 
ADD UNIQUE INDEX `identity_type_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `identity_type_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='identity_type';

DELETE n1 FROM hostel_cancellation_reason n1, hostel_cancellation_reason n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM hostel_cancellation_reason n1, hostel_cancellation_reason n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `hostel_cancellation_reason` 
ADD UNIQUE INDEX `hostel_cancellation_reason_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `hostel_cancellation_reason_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='hostel_cancellation_reason';

DELETE n1 FROM hostel_checkout_reason n1, hostel_checkout_reason n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM hostel_checkout_reason n1, hostel_checkout_reason n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `hostel_checkout_reason` 
ADD UNIQUE INDEX `hostel_checkout_reason_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `hostel_checkout_reason_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='hostel_checkout_reason';

DELETE n1 FROM hostel_status_change_reason n1, hostel_status_change_reason n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM hostel_status_change_reason n1, hostel_status_change_reason n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `hostel_status_change_reason` 
ADD UNIQUE INDEX `hostel_status_change_reason_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `hostel_status_change_reason_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='hostel_status_change_reason';

DELETE n1 FROM hr_leave_document_master n1, hr_leave_document_master n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM hr_leave_document_master n1, hr_leave_document_master n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `hr_leave_document_master` 
ADD UNIQUE INDEX `hr_leave_document_master_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `hr_leave_document_master_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='hr_leave_document_master';

DELETE n1 FROM enq_program_master n1, enq_program_master n2 
WHERE n1.id < n2.id AND n1.programCode = n2.programCode;
DELETE n1 FROM enq_program_master n1, enq_program_master n2 
WHERE n1.id < n2.id AND n1.programName = n2.programName;

update enq_program_master set programCode = programName where programCode is null and programName is not null;
update enq_program_master set programName = programCode where programName is null and programCode is not null;
delete from enq_program_master where programCode is null and programName is null;

ALTER TABLE `enq_program_master` 
CHANGE COLUMN `programCode` `programCode` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `enq_program_master_code_unique` (`programCode` ASC),
ADD UNIQUE INDEX `enq_program_master_value_unique` (`programName` ASC);

update templog_standardMasterUniqueCheck set msg ='enq_program_master';

DELETE n1 FROM enquiry_type n1, enquiry_type n2 
WHERE n1.id < n2.id AND n1.code = n2.code;
DELETE n1 FROM enquiry_type n1, enquiry_type n2 
WHERE n1.id < n2.id AND n1.enquiryTypeName = n2.enquiryTypeName;

update enquiry_type set code = enquiryTypeName where code is null and enquiryTypeName is not null;
update enquiry_type set enquiryTypeName = code where enquiryTypeName is null and code is not null;
delete from enquiry_type where code is null and enquiryTypeName is null;

ALTER TABLE `enquiry_type` 
CHANGE COLUMN `code` `code` VARCHAR(255) NOT NULL ,
CHANGE COLUMN `enquiryTypeName` `enquiryTypeName` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `enquiry_type_code_unique` (`code` ASC),
ADD UNIQUE INDEX `enquiry_type_value_unique` (`enquiryTypeName` ASC);

update templog_standardMasterUniqueCheck set msg ='enquiry_type';

DELETE n1 FROM invt_publisher_master n1, invt_publisher_master n2 
WHERE n1.id < n2.id AND n1.publisherName = n2.publisherName;

ALTER TABLE `invt_publisher_master` 
ADD UNIQUE INDEX `invt_publisher_master_value_unique` (`publisherName` ASC);

update templog_standardMasterUniqueCheck set msg ='invt_publisher_master';

DELETE n1 FROM invt_service_provider_master n1, invt_service_provider_master n2 
WHERE n1.id < n2.id AND n1.providerName = n2.providerName;

ALTER TABLE `invt_service_provider_master` 
ADD UNIQUE INDEX `invt_service_provider_master_value_unique` (`providerName` ASC);

update templog_standardMasterUniqueCheck set msg ='invt_service_provider_master';

DELETE n1 FROM publication_index n1, publication_index n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM publication_index n1, publication_index n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `publication_index` 
ADD UNIQUE INDEX `publication_index_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `publication_index_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='publication_index';

DELETE n1 FROM publication_year n1, publication_year n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM publication_year n1, publication_year n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `publication_year` 
ADD UNIQUE INDEX `publication_year_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `publication_year_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='publication_year';

DELETE n1 FROM research_type n1, research_type n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM research_type n1, research_type n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `research_type` 
ADD UNIQUE INDEX `research_type_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `research_type_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='research_type';

DELETE n1 FROM seminar_type n1, seminar_type n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM seminar_type n1, seminar_type n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `seminar_type` 
ADD UNIQUE INDEX `seminar_type_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `seminar_type_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='seminar_type';

DELETE n1 FROM training_type n1, training_type n2 
WHERE n1.id < n2.id AND n1.itemCode = n2.itemCode;
DELETE n1 FROM training_type n1, training_type n2 
WHERE n1.id < n2.id AND n1.itemValue = n2.itemValue;

ALTER TABLE `training_type` 
ADD UNIQUE INDEX `training_type_code_unique` (`itemCode` ASC),
ADD UNIQUE INDEX `training_type_value_unique` (`itemValue` ASC);

update templog_standardMasterUniqueCheck set msg ='training_type';

INSERT INTO `country` (`code`, `countryName`, `lastUpdatedBy`) VALUES ('Other', 'Other', '1');
INSERT INTO `country_region` (`countryId`, `code`, `countryRegionName`, `countryRegionType`, `lastUpdatedBy`) VALUES ((select id from country where countryName ='Other'), 'Other', 'Other', 'Other', '1');
update `city` set `countryId` = (select `id` from `country` where `countryName` ='Other') where `countryId` is null;
update `city` set `countryRegionId` = (select `id` from `country_region` where `countryRegionName` ='Other') where `countryRegionId` is null;

DELETE n1 FROM city n1, city n2 
WHERE n1.id < n2.id AND n1.code = n2.code AND n1.countryRegionId = n2.countryRegionId AND n1.countryId = n2.countryId;
DELETE n1 FROM city n1, city n2 
WHERE n1.id < n2.id AND n1.cityName = n2.cityName AND n1.countryRegionId = n2.countryRegionId AND n1.countryId = n2.countryId;

update city set code = cityName where code is null;
update city set cityName = code where cityName is null;
delete from city where code is null and cityName is null;

ALTER TABLE `city` 
DROP FOREIGN KEY `Refcountry406`,
DROP FOREIGN KEY `Refcountryregion`;
ALTER TABLE `city` 
CHANGE COLUMN `countryId` `countryId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `countryRegionId` `countryRegionId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `code` `code` VARCHAR(255) NOT NULL ,
CHANGE COLUMN `cityName` `cityName` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `city_code_unique` (`countryId` ASC, `countryRegionId` ASC, `code` ASC),
ADD UNIQUE INDEX `city_name_unique` (`countryId` ASC, `countryRegionId` ASC, `cityName` ASC);
ALTER TABLE `city` 
ADD CONSTRAINT `Refcountry406`
  FOREIGN KEY (`countryId`)
  REFERENCES `country` (`id`),
ADD CONSTRAINT `Refcountryregion`
  FOREIGN KEY (`countryRegionId`)
  REFERENCES `country_region` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
  
update templog_standardMasterUniqueCheck set msg ='city';

DELETE n1 FROM country_region n1, country_region n2 
WHERE n1.id < n2.id AND n1.code = n2.code AND n1.countryId = n2.countryId;
DELETE n1 FROM country_region n1, country_region n2 
WHERE n1.id < n2.id AND n1.countryRegionName = n2.countryRegionName AND n1.countryId = n2.countryId;

ALTER TABLE `country_region` 
DROP FOREIGN KEY `Refcountry31`;
ALTER TABLE `country_region` 
CHANGE COLUMN `countryId` `countryId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `code` `code` VARCHAR(255) NOT NULL ,
CHANGE COLUMN `countryRegionName` `countryRegionName` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `country_region_code_unique` (`countryId` ASC,`code` ASC),
ADD UNIQUE INDEX `country_region_value_unique` (`countryId` ASC,`countryRegionName` ASC);
ALTER TABLE `country_region` 
ADD CONSTRAINT `Refcountry31`
  FOREIGN KEY (`countryId`)
  REFERENCES `country` (`id`);
  
update templog_standardMasterUniqueCheck set msg ='country_region';

DELETE n1 FROM country n1, country n2 
WHERE n1.id < n2.id AND n1.code = n2.code;
DELETE n1 FROM country n1, country n2 
WHERE n1.id < n2.id AND n1.countryName = n2.countryName;

update country set code = countryName where code is null;
update country set countryName = code where countryName is null;
delete from country where code is null and countryName is null;

ALTER TABLE `country` 
CHANGE COLUMN `code` `code` VARCHAR(255) NOT NULL ,
CHANGE COLUMN `countryName` `countryName` VARCHAR(255) NOT NULL ,
ADD UNIQUE INDEX `country_code_unique` (`code` ASC),
ADD UNIQUE INDEX `country_value_unique` (`countryName` ASC);

update templog_standardMasterUniqueCheck set msg ='country';


update standard_master_items set wheherNullable=b'0' where standardMasterId in(
select id from standard_master where tableName in('application_prog_rejection_reasons', 'examination_name', 'examination_year',
'result_status', 'study_mode', 'exam_document_name', 'domicile', 'identity_type', 'hostel_cancellation_reason', 'hostel_checkout_reason',
'hostel_status_change_reason', 'hr_leave_document_master', 'enq_intermediate_type', 'enq_program_master', 'enquiry_source',
'publication_index', 'publication_year', 'research_type', 'seminar_type', 'training_type'));

update templog_standardMasterUniqueCheck set msg ='COMPLETE';

COMMIT;   

END$$
DELIMITER ;

