set sql_safe_updates = 0;
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,
     pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,
     psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,
     b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate
     FROM application_program aprgm
     LEFT JOIN programs p ON aprgm.programId = p.id
     LEFT JOIN prog_batch_seat_config pbsc ON aprgm.progBatchSeatConfigId = pbsc.id
     LEFT JOIN batches b   ON b.id = pbsc.programBatchId
     LEFT JOIN department pd ON pd.id = p.programDepartmentId
     LEFT JOIN department psd ON psd.id = p.subDepartmentId',
    resultColumnsDef = 'program_code,program_name,program_print_name,primary_dept_code,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate'
WHERE
    `dataSourceCode` = 'APPLICATION_INFO'
        AND `executionOrder` = 2;
        
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT ap.firstName AS applicant_firstname ,ap.lastName AS applicant_lastname ,ap.middleName AS applicant_middlename, 
     ap.gender AS applicant_gender,ap.printName  AS applicant_printname,a.code as application_code,
     s.salutationName as applicant_salutation,ap.birthDate as birth_date,ap.photoUrl as app_photo_url
     FROM application a
     LEFT JOIN  applicant_person ap ON a.applicantPersonId = ap.id
     LEFT JOIN salutations s ON ap.salutationId = s.id',
    resultColumnsDef = 'applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,application_code,applicant_salutation,birth_date,app_photo_url'
WHERE
    `dataSourceCode` = 'APPLICATION_INFO'
        AND executionOrder = '3';
        
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT b.bankCode AS bank_code,b.ifscCode AS ifsc_code,b.accountNo AS bank_account_no, b.bankName AS bank_name,
    b.branchName AS branch_name,b.branchAddress AS bank_branch_address
    FROM bank b
    INNER JOIN academies a ON b.academyId = a.id
    INNER JOIN locations l ON b.locationId = l.id
    INNER JOIN academy_location al ON al.academyId = a.id AND al.locationId = l.id'
WHERE
    `dataSourceCode` = 'ACADEMY_LOCATION_BANKS';
    
set sql_safe_updates = 1;