
DELIMITER //

CREATE TRIGGER identity_type_after_insert
AFTER INSERT
   ON identity_type FOR EACH ROW
BEGIN
   -- Insert record into other table
   INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Personal Information',NEW.itemValue, 'Identity Cards', 'APPLICANT', NEW.id,
   'SELECT T4.path AS value FROM identity_type T1 LEFT JOIN identity_detail T2 ON T1.id = T2.idType 
LEFT JOIN identity_detail_document T3 ON T3.identityDetailId = T2.id 
LEFT JOIN documents T4 ON T4.id = T3.documentId where T2.applicantPersonId = $param1 and T1.itemValue = $param2 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Personal Information',NEW.itemValue, 'Identity Cards', 'STUDENT', NEW.id,
   'SELECT T4.path AS value FROM identity_type T1 LEFT JOIN identity_detail T2 ON T1.id = T2.idType 
LEFT JOIN identity_detail_document T3 ON T3.identityDetailId = T2.id 
LEFT JOIN documents T4 ON T4.id = T3.documentId where T2.personId = $param1 and T1.itemValue = $param2 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Personal Information',NEW.itemValue, 'Identity Cards', 'EMPLOYEE', NEW.id,
   'SELECT T4.path AS value FROM identity_type T1 LEFT JOIN identity_detail T2 ON T1.id = T2.idType 
LEFT JOIN identity_detail_document T3 ON T3.identityDetailId = T2.id 
LEFT JOIN documents T4 ON T4.id = T3.documentId where T2.personId = $param1 and T1.itemValue = $param2 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

END; //

DELIMITER ;

DELIMITER //

CREATE TRIGGER identity_type_after_update
AFTER UPDATE
   ON identity_type FOR EACH ROW
BEGIN
   -- Update record into other table
   UPDATE bulk_document_group SET documentName = NEW.itemValue, lastUpdate = NEW.lastUpdate,
   lastUpdatedBy = NEW.lastUpdatedBy WHERE documentName = OLD.itemValue
   and documentId = OLD.id;
END; //

DELIMITER ;

DELIMITER //

CREATE TRIGGER identity_type_after_delete
AFTER DELETE
   ON identity_type FOR EACH ROW
BEGIN
   DELETE FROM bulk_document_group WHERE documentName = OLD.itemValue
   and documentId = OLD.id;
END; //

DELIMITER ; 