
DELIMITER //

CREATE TRIGGER training_type_after_insert
AFTER INSERT
   ON training_type FOR EACH ROW
BEGIN
      -- Insert record into other table
INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Training Details', 'STUDENT', NEW.id,
   'select T4.path AS value from training_type T1 LEFT JOIN person_training_details T2 ON T1.id = T2.trainingTypeId 
LEFT JOIN person_training_documents T3 ON T3.personTrainingId = T2.id
LEFT JOIN documents T4 ON T4.id = T3.documentId where T2.personId = 11 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Training Details', 'EMPLOYEE', NEW.id,
   'select T4.path AS value from training_type T1 LEFT JOIN person_training_details T2 ON T1.id = T2.trainingTypeId 
LEFT JOIN person_training_documents T3 ON T3.personTrainingId = T2.id
LEFT JOIN documents T4 ON T4.id = T3.documentId where T2.personId = 11 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

END; //

DELIMITER ;

DELIMITER //

CREATE TRIGGER training_type_after_update
AFTER UPDATE
   ON training_type FOR EACH ROW
BEGIN
   UPDATE bulk_document_group SET documentName = NEW.itemValue, lastUpdate = NEW.lastUpdate,
   lastUpdatedBy = NEW.lastUpdatedBy WHERE documentName = OLD.itemValue
   and documentId = OLD.id;
END; //

DELIMITER ;

DELIMITER //

CREATE TRIGGER training_type_after_delete
AFTER DELETE
   ON training_type FOR EACH ROW
BEGIN
   DELETE FROM bulk_document_group WHERE documentName = OLD.itemValue
   and documentId = OLD.id;
END; //

DELIMITER ; 