DROP procedure IF EXISTS `rpt_Application_Summary`;
DELIMITER $$
CREATE  PROCEDURE `rpt_Application_Summary`(academyLocation text, intakeYear int(10), StartDate date, EndDate date, ProgramCategory int(10), ProgramGroup int(10))
BEGIN
   /* Declaration of nullable parameter ******************************************/
   declare StartDateNull, EndDateNull, ProgramCategoryNull, ProgramGroupNull boolean;

   -- for deploying updates settings
   SET SQL_SAFE_UPDATES = 0;
   
   -- a procedure to convert multi valued parameter string to multiple rows
   call str_to_row (academyLocation);

   -- setting nullable parameters as per parameters for query execution
   if StartDate is null then
  	set StartDateNull = 1;
   else set StartDateNull = 0;
   end if;
   if EndDate is null then
  	set EndDateNull = 1;
   else set EndDateNull = 0;
   end if;
   if ProgramCategory is null then
  	set ProgramCategoryNull = 1;
   else set ProgramCategoryNull = 0;
   end if;
   if ProgramGroup is null then
  	set ProgramGroupNull = 1;
   else set ProgramGroupNull = 0;
   end if;

   /* Recreation of temporary tables *********************************************/
	drop table if exists tbl_rpt_Application_Summary;
	create table tbl_rpt_Application_Summary(Brand_Campus varchar(250), Brand_Campus_ID int, programId int, grade varchar(50), Total_SUCCESSFUL_Admission int default 0, Total_UNSuccessful int default 0, Total_Enq int default 0, convert_perc_lead double default 0, Weekly_movement_Tot_Success_Approve_Apps int default 0, Target_total_success_approv_apps int default 0, Perc_Target_Total_Success_Approve_App double default 0, YOY_Variance_Total_Approve_Application_target int default 0, Total_SUCCESSFUL_Admission_prev int default 0, total_converted_enq int default 0)
	comment 'Temporary Table for Application Summary Report';

/* Data for Application summary is retrieved on the basis of parameter
   * Academy Locations (id)s -- Mandatory
   * Intake Year (id)    	-- Mandatory
   * Start Date (date)   	-- Optional
   * End Date (date)     	-- Optional
   * Program Category (id)   -- Optional
   * Program Group (id)  	-- Optional
   * *********************************************************************************************/

   /* Insertion of basic required data(Academy Location having Programs) **********/
	insert into tbl_rpt_Application_Summary(Brand_Campus, Brand_Campus_ID, programId, grade)
	select concat(al.academyName, '-', al.locationName), al.id, p.id, p.programNameToBePrint
		from academy_location al join programs p on al.id = p.academyLocationId and p.status = 'O'
		join batches as b on p.id = b.programId
		where p.programClosureDate is null
			and al.id in (select s from tbl_str_to_row) and b.intakeYearId = intakeYear
		and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
		and ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
		and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		group by al.id, p.id;

	-- Total Successful/Approved Applications
	update tbl_rpt_Application_Summary as t, (Select al.id as alId, count(distinct a.code) as Total_SUCCESSFUL_Admission, p.id as programid
		from application a join application_program ap on a.id=ap.applicationId
		join programs p on p.id=ap.programId
		join academy_location al on al.id=ap.academyLocationId and al.id in (select s from tbl_str_to_row)
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		where a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
			and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
 			and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
			and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
			and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		group by al.id, p.id) as tot
	set t.Total_SUCCESSFUL_Admission = tot.Total_SUCCESSFUL_Admission
	where t.Brand_Campus_ID = tot.alId and t.programId = tot.programid;
/*


insert into tbl_rpt_Application_Summary(Brand_Campus, grade, Total_SUCCESSFUL_Admission, programId, Brand_Campus_ID)
Select al.displayName as Brand_Campus,p.programNameToBePrint as grade,count(a.id) as Total_SUCCESSFUL_Admission, p.id, al.id as alId 
from application a right join application_program ap on a.id=ap.applicationId
left join programs p on p.id=ap.programId
left join academy_location al on al.id=ap.academyLocationId
where a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
group by al.id,p.programNameToBePrint;
*/

	update tbl_rpt_Application_Summary as t, (Select al.id as alId, count(distinct a.id) as Total_UNSuccessful, p.id as programid
		from application a join application_program ap on a.id=ap.applicationId
		join programs p on p.id = ap.programId
		join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		where a.currentStatus in ('REJECTED','WITHDRAWN')
			and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
 			and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
			and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
			and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		group by al.id, p.id) as q
	set t.Total_UNSuccessful = ifnull(q.Total_UNSuccessful,0)
	where t.Brand_Campus_ID = q.alId and t.programid = q.programid;

	/*
	update tbl_rpt_Application_Summary as t, (Select al.displayName as Brand_Campus,p.programNameToBePrint as grade, count(a.id) as Total_UNSuccessful 
	from application a right join application_program ap on a.id=ap.applicationId
	left join programs p on p.id=ap.programId
	left join academy_location al on al.id=ap.academyLocationId
	where a.currentStatus in ('REJECTED','WITHDRAWN')
	group by p.programNameToBePrint,al.id) as q
	set t.Total_UNSuccessful = ifnull(q.Total_UNSuccessful,0)
	where t.Brand_Campus = q.Brand_Campus and t.grade = q.grade;
	*/

update tbl_rpt_Application_Summary as t, 
(select al.displayName, e.academyLocationId, p.programNameToBePrint, aed.programId, p.programName, count(distinct e.id) as Total_Enq 
from academy_location as al, programs as p, enquiry e
join enq_student_details esd on esd.enquiryId = e.id
join admission_enq_details aed on aed.enqStudentDetailsId = esd.id
join batches b on b.id = aed.batchId and b.intakeYearId = intakeYear
join intake_year iy on iy.id = b.intakeYearId
where e.academyLocationId in (select s from tbl_str_to_row) and al.id = e.academyLocationId
and aed.programId = p.id and p.status = 'O' and al.id = p.academyLocationId
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
	or ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by e.academyLocationId, aed.programId) as q
set t.Total_Enq = q.Total_Enq
where t.Brand_Campus_ID = q.academyLocationId and t.programId = q.programId;

/*
update tbl_rpt_Application_Summary as t, 
(select al.displayName, e.academyLocationId, p.programNameToBePrint, aed.programId, p.programName, count(1) as Total_Enq 
from academy_location as al, programs as p, enquiry e
left join enq_student_details esd on esd.enquiryId = e.id
left join admission_enq_details aed on aed.enqStudentDetailsId = esd.id
left join batches b on b.id = aed.batchId and b.intakeYearId = intakeYear
left join intake_year iy on iy.id = b.intakeYearId
where e.academyLocationId in (select s from tbl_str_to_row) and al.id = e.academyLocationId
and aed.programId = p.id
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
	or ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by e.academyLocationId, aed.programId) as q
set t.Brand_Campus_ID = q.academyLocationId, t.programId = q.programId, t.Total_Enq = q.Total_Enq-- and t.grade = q.programName
where t.Brand_Campus = q.displayName and t.grade = q.programNameToBePrint;

insert into tbl_rpt_Application_Summary(Brand_Campus, Brand_Campus_ID, programId, Total_Enq)
select temp.displayName, temp.academyLocationId, temp.programId, temp.Total_Enq 
from (select al.displayName, e.academyLocationId, aed.programId, count(1) as Total_Enq 
from academy_location as al, programs as p, enquiry e
left join enq_student_details esd on esd.enquiryId = e.id
left join admission_enq_details aed on aed.enqStudentDetailsId = esd.id
left join batches b on b.id = aed.batchId
left join intake_year iy on iy.id = b.intakeYearId
where e.academyLocationId in (2,3,4,5,1,6) and al.id = e.academyLocationId
and b.intakeYearId = 1 and aed.programId = p.id
group by e.academyLocationId, aed.programId) as temp
left join tbl_rpt_Application_Summary as t on (t.Brand_Campus = temp.displayName and t.Brand_Campus_ID = temp.academyLocationId and t.programId = temp.programId)
where t.Brand_Campus is null;
*/


/*
insert into tbl_rpt_Application_Summary(Brand_Campus, Brand_Campus_ID, grade, programId, Total_Enq)
select temp.displayName, temp.academyLocationId, temp.programName, temp.programId, temp.Total_Enq 
from (select al.displayName, e.academyLocationId, aed.programId, p.programName, count(1) as Total_Enq 
from academy_location as al, programs as p, enquiry e
left join enq_student_details esd on esd.enquiryId = e.id
left join admission_enq_details aed on aed.enqStudentDetailsId = esd.id
left join batches b on b.id = aed.batchId and b.intakeYearId = intakeYear
left join intake_year iy on iy.id = b.intakeYearId
where e.academyLocationId in (select s from tbl_str_to_row) and al.id = e.academyLocationId
and aed.programId = p.id
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
	or ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by e.academyLocationId, aed.programId) as temp
left join tbl_rpt_Application_Summary as t on (t.Brand_Campus = temp.displayName and t.Brand_Campus_ID = temp.academyLocationId and t.programId = temp.programId)
where t.Brand_Campus is null;
*/

/*, date_sub(current_date(), interval WEEKDAY(current_date()) -(case when weekStart = 'MONDAY' then 0 
when weekStart = 'TUESDAY' then 1 when weekStart = 'WEDNESDAY' then 2 when weekStart = 'THURSDAY' then 3
when weekStart = 'FRIDAY' then 4 when weekStart = 'SATURDAY' then 5 end) day) as lastmonday
select weekStart, date_sub(current_date(), interval WEEKDAY(current_date()) -(case when weekStart = 'MONDAY' then 0 
when weekStart = 'TUESDAY' then 1 when weekStart = 'WEDNESDAY' then 2 when weekStart = 'THURSDAY' then 3
when weekStart = 'FRIDAY' then 4 when weekStart = 'SATURDAY' then 5 end) day) as lastmonday
, date_sub(current_date(), interval WEEKDAY(current_date()) -(case when weekStart = 'MONDAY' then 0 
when weekStart = 'TUESDAY' then 1 when weekStart = 'WEDNESDAY' then 2 when weekStart = 'THURSDAY' then 3
when weekStart = 'FRIDAY' then 4 when weekStart = 'SATURDAY' then 5 end) + 7 day) as pen_day
from calendars; 
*/
/*
update tbl_rpt_Application_Summary
set tbl_rpt_Application_Summary.convert_perc_lead = ifnull((tbl_rpt_Application_Summary.Total_SUCCESSFUL_Admission/ tbl_rpt_Application_Summary.total_enq) * 100,0);
*/

update tbl_rpt_Application_Summary as t, (Select al.id as alId, count(distinct a.id) as Total_sucessful_wrt_lead, p.id as programid
		from application a join application_program ap on a.id=ap.applicationId
		join programs p on p.id = ap.programId
		join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId =  intakeYear
		where a.saleRefId is not null
/*			and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
 			and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
			and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
			and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
	*/	group by al.id, p.id) as q
set t.convert_perc_lead = ifnull((q.Total_sucessful_wrt_lead/ t.total_enq) * 100,0),
t.total_converted_enq = ifnull(q.Total_sucessful_wrt_lead,0) 
where t.Brand_Campus_ID = q.alId and t.programId = q.programId;

/* Column e ***********************************/
/*
update tbl_rpt_Application_Summary, (Select al.displayName as Brand_Campus, p.programNameToBePrint as grade,count(a.id) as convert_perc_lead, p.id, al.id as alId
from application a right join application_program ap on a.id=ap.applicationId
left join programs p on p.id = ap.programId
left join academy_location al on al.id=ap.academyLocationId
left join batches as b on b.programId = p.id and b.intakeYearId = intakeYear
where a.saleRefType = 'ENQUIRED_EARLIER' and ap.academyLocationId in (select s from tbl_str_to_row) 
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
	or ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by al.id, p.id) as q
set tbl_rpt_Application_Summary.convert_perc_lead = q.convert_perc_lead
where tbl_rpt_Application_Summary.Brand_Campus = q.Brand_Campus and tbl_rpt_Application_Summary.grade = q.grade;
*/
/******************************** to be checked later
update tbl_rpt_Application_Summary, (Select al.displayName as Brand_Campus, p.programNameToBePrint as grade,count(a.id) as convert_perc_lead, p.id, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId and p.status = 'O'
join academy_location al on al.id = ap.academyLocationId
join batches as b on b.programId = p.id and b.intakeYearId = intakeYear
where a.saleRefType = 'ENQUIRED_EARLIER' and ap.academyLocationId in (select s from tbl_str_to_row) 
	and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
	and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by al.id, p.id) as q
set tbl_rpt_Application_Summary.convert_perc_lead = q.convert_perc_lead
where tbl_rpt_Application_Summary.Brand_Campus_ID = q.alId and tbl_rpt_Application_Summary.programId = q.id;
*****************************************************************/
/* column f : this week's applications *******************/
/*update tbl_rpt_Application_Summary as t, (select al.displayName, ap.programId, count(a.code) as app_this_week, group_concat(a.currentStatus), a.applicationCreatedOn, calendars.weekStart, ap.academyLocationId, al.academyName, al.academyId, al.locationId, al.locationName
from application as a right join application_program ap on a.id=ap.applicationId
left join academy_location al on al.id = ap.academyLocationId
join academy_location_purpose alp on al.id = alp.academyLocationId
join calendars on alp.calendarId = calendars.id join batches as b on b.programId = ap.programId
join programs as p on p.id = ap.programId
where a.applicationCreatedOn between (date_sub(current_date(), interval WEEKDAY(current_date()) - (case when weekStart = 'MONDAY' then 0 
when weekStart = 'TUESDAY' then 1 
when weekStart = 'WEDNESDAY' then 2 
when weekStart = 'THURSDAY' then 3
when weekStart = 'FRIDAY' then 4 
when weekStart = 'SATURDAY' then 5 end) day)) 
and current_date()
and a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
and academyLocationId in (select s from tbl_str_to_row) 
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
	or ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by al.displayName, ap.programId) as q
set Weekly_movement_Tot_Success_Approve_Apps = q.app_this_week
where t.Brand_Campus = q.displayName and t.programId = q.programId;*/

update tbl_rpt_Application_Summary as t, (select al.id as alid, ap.programId, count(distinct a.code) as app_this_week
	from application a join application_program ap on a.id=ap.applicationId
		join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
		join academy_location_purpose alp on al.id = alp.academyLocationId
		join calendars on alp.calendarId = calendars.id
		join programs p on p.id = ap.programId and p.status =  'O'
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.applicationCreatedOn between (date_sub(current_date(), interval WEEKDAY(current_date()) - (case when weekStart = 'MONDAY' then 0 
when weekStart = 'TUESDAY' then 1 
when weekStart = 'WEDNESDAY' then 2 
when weekStart = 'THURSDAY' then 3
when weekStart = 'FRIDAY' then 4 
when weekStart = 'SATURDAY' then 5 end) day)) and current_date()
and a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by al.id, ap.programId) as q
set Weekly_movement_Tot_Success_Approve_Apps = q.app_this_week
where t.Brand_Campus_ID = q.alid and t.programId = q.programId;

/* column g *************************************/
update tbl_rpt_Application_Summary, (select mt.academyLocationId, applicationTarget as target_for_Total_success_approve_app, mt.intakeYearId, mt.programId, mt.batchId 
from manage_target as mt join programs as p on p.id = mt.programId and mt.intakeYearId = intakeYear
join batches as b on b.programId = p.id
where mt.academyLocationId in (select s from tbl_str_to_row) 
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
and ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)) as q
set tbl_rpt_Application_Summary.Target_total_success_approv_apps = ifnull(q.target_for_Total_success_approve_app,0)
where tbl_rpt_Application_Summary.Brand_Campus_ID = q.academyLocationId and tbl_rpt_Application_Summary.programId = q.programId;

/* column h ************************************/
update tbl_rpt_Application_Summary set Perc_Target_Total_Success_Approve_App = ifnull(Total_SUCCESSFUL_Admission / Target_total_success_approv_apps * 100,0);

/* column i ************************************/
update tbl_rpt_Application_Summary as tbl, (select curr_intake.alId, curr_intake.id, prev_intake.Total_SUCCESSFUL_Admission as Total_SUCCESSFUL_Admission_prev, curr_intake.Total_SUCCESSFUL_Admission
, ifnull(((curr_intake.Total_SUCCESSFUL_Admission - prev_intake.Total_SUCCESSFUL_Admission)/prev_intake.Total_SUCCESSFUL_Admission * 100),0) as YOY_Variance_Total_Approve_Application_target
from (Select count(distinct a.code) as Total_SUCCESSFUL_Admission, p.id, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join prog_batch_seat_config as pb on ap.progBatchSeatConfigId = pb.id
join batches as b on b.id = pb.programBatchId and b.intakeYearId = intakeYear
where a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by al.id, p.id) as curr_intake
left join (Select count(distinct a.id) as Total_SUCCESSFUL_Admission, p.id, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join prog_batch_seat_config as pb on ap.progBatchSeatConfigId = pb.id
join batches as b on b.id = pb.programBatchId and b.intakeYearId = (select id from intake_year 
	where itemValue = (select itemValue - 1 from intake_year where id = intakeYear))
where a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by al.id, p.id) as prev_intake
on prev_intake.alId = curr_intake.alId and prev_intake.id = curr_intake.id) as dat
set tbl.YOY_Variance_Total_Approve_Application_target = dat.YOY_Variance_Total_Approve_Application_target
, tbl.Total_SUCCESSFUL_Admission_prev = dat.Total_SUCCESSFUL_Admission_prev
where tbl.Brand_Campus_Id = dat.alId and tbl.programId = dat.id;
/***************************
update tbl_rpt_Application_Summary as tbl, (select curr_intake.Brand_Campus, curr_intake.grade
, curr_intake.id, prev_intake.Total_SUCCESSFUL_Admission as Total_SUCCESSFUL_Admission_prev, curr_intake.Total_SUCCESSFUL_Admission
, ifnull(((curr_intake.Total_SUCCESSFUL_Admission - prev_intake.Total_SUCCESSFUL_Admission)/curr_intake.Total_SUCCESSFUL_Admission - prev_intake.Total_SUCCESSFUL_Admission * 100),0) as YOY_Variance_Total_Approve_Application_target
from
(Select al.displayName as Brand_Campus, p.programNameToBePrint as grade,count(a.id) as Total_SUCCESSFUL_Admission
, p.id, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId
join batches on p.id = batches.programId and batches.intakeYearId = intakeYear
join prog_batch_period_config as pb on pb.programBatchId = batches.id
where a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
and current_Date() between programPeriodStart and programPeriodEnd
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
group by al.id, p.programNameToBePrint) as curr_intake
left join (Select al.displayName as Brand_Campus, p.programNameToBePrint as grade,count(a.id) as Total_SUCCESSFUL_Admission
, p.id, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId
join batches on p.id = batches.programId and batches.intakeYearId = intakeYear
join prog_batch_period_config as pb on pb.programBatchId = batches.id
where a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and date_sub(current_Date(), interval 1 year) between programPeriodStart and programPeriodEnd
group by al.id, p.programNameToBePrint) as prev_intake
on prev_intake.Brand_Campus = curr_intake.Brand_Campus and prev_intake.grade = curr_intake.grade
and prev_intake.id = curr_intake.id) as dat
set tbl.YOY_Variance_Total_Approve_Application_target = dat.YOY_Variance_Total_Approve_Application_target
where tbl.Brand_Campus = dat.Brand_Campus and tbl.grade = dat.grade and tbl.programId = dat.id;
*/

select Brand_Campus, grade, Total_SUCCESSFUL_Admission, Total_UNSuccessful, convert_perc_lead,  Weekly_movement_Tot_Success_Approve_Apps, Target_total_success_approv_apps, Perc_Target_Total_Success_Approve_App, YOY_Variance_Total_Approve_Application_target, total_enq, Total_SUCCESSFUL_Admission_prev, total_converted_enq
from tbl_rpt_Application_Summary  order by Brand_Campus;

END$$
DELIMITER ;