CREATE TABLE `hr_emp_leave_request` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `requestUserId` bigint(20) NOT NULL,
  `fromDate` date NOT NULL,
  `toDate` date NOT NULL,
  `hrLeaveTypeId` bigint(20) NOT NULL,
  `reason` varchar(225) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT '0' COMMENT '0: Pending , 1 : Approved, 2 : Reject, 3: Canceled',
  `requestDate` date DEFAULT NULL,
  `alternateEmpNames` varchar(225) DEFAULT NULL,
  `fromDuration` varchar(10) DEFAULT NULL,
  `toDuration` varchar(10) DEFAULT NULL,
  `whetherDocumentUploaded` tinyint(1) DEFAULT '0',
  `documentLocation` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  KEY `hr_emp_leave_request_ibfk_1` (`requestUserId`),
  KEY `fk_hr_emp_leave_request_leaveTypeId_idx` (`hrLeaveTypeId`),
  CONSTRAINT `fk_hr_emp_leave_request_leaveTypeId` FOREIGN KEY (`hrLeaveTypeId`) REFERENCES `hr_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `hr_emp_leave_request_ibfk_1` FOREIGN KEY (`requestUserId`) REFERENCES `users` (`id`),
  CONSTRAINT `hr_emp_leave_request_ibfk_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
