set sql_safe_updates=0;
ALTER TABLE `fee_payer_detail` 
ADD COLUMN `sponsorId` BIGINT(20) NULL DEFAULT NULL COMMENT '' AFTER `emailWorkUseForCommunication`,
ADD INDEX `fk_fee_payer_detail_sponsorId_idx` (`sponsorId` ASC)  COMMENT '';
ALTER TABLE `fee_payer_detail` 
ADD CONSTRAINT `fk_fee_payer_detail_sponsorId`
  FOREIGN KEY (`sponsorId`)
  REFERENCES `sponsors` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
ALTER TABLE `sponsorship_awarded_items` 
ADD COLUMN `programBatchSeatConfigId` BIGINT(20) NULL DEFAULT NULL COMMENT '' AFTER `feePlanRuleStageId`,
ADD INDEX `fk_sponsorship_awarded_items_program_batch_seat_config_idx` (`programBatchSeatConfigId` ASC)  COMMENT '';
ALTER TABLE `sponsorship_awarded_items` 
ADD CONSTRAINT `fk_sponsorship_awarded_items_program_batch_seat_config`
  FOREIGN KEY (`programBatchSeatConfigId`)
  REFERENCES `prog_batch_seat_config` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
set sql_safe_updates=0;
  
UPDATE sponsorship_awarded_items sai
        LEFT OUTER JOIN
    admission a ON a.id = sai.admissionId
        LEFT OUTER JOIN
    prog_batch_seat_config pbsc ON a.programBatchSeatConfigId = pbsc.id 
SET 
    sai.programBatchSeatConfigId = pbsc.id;
    
 set sql_safe_updates=1;

ALTER TABLE `sponsorship_awarded_items` 
ADD COLUMN `feeStageId` BIGINT(20) NULL DEFAULT NULL COMMENT '' AFTER `feePlanRuleStageId`,
ADD INDEX `fk_sponsorship_awarded_items_fee_plan_rule_stage_idx` (`feeStageId` ASC)  COMMENT '';
ALTER TABLE `sponsorship_awarded_items` 
ADD CONSTRAINT `fk_sponsorship_awarded_items_fee_plan_rule_stage`
  FOREIGN KEY (`feeStageId`)
  REFERENCES `fee_plan_rule_stage` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

set sql_safe_updates=0;

UPDATE sponsorship_awarded_items sai
        LEFT OUTER JOIN
    fee_stage_head_config fshc ON sai.feeStageHeadConfigId = fshc.id 
		left outer join
	fee_plan_rule_stage fprs on fshc.feePlanRuleStageId=fprs.id 
SET 
    sai.feeStageId = fprs.id;  
set sql_safe_updates=1;