-- V2D-25969

SET SQL_SAFE_UPDATES = 0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_MSG_ATTENDANCE_STUDENT_CD');
update `sql_dtprovider` set `sqlQuery` = "SELECT T14.`id` AS ID,
T5.`firstName` AS FIRST_NAME,
T5.`middleName` AS MIDDLE_NAME,
T5.`lastName` AS LAST_NAME,
T6.`salutationName` AS SALUTATION,
T2.`dateOfAttendance` AS DATE_OF_ATTENDANCE,
T5.`emailId` AS EMAIL_ID,
T5.`mobileNumber` AS MOBILE_NO,
T5.`mobileCountryCode` AS MOBILE_CODE,
T7.`itemValue` as ATTENDANCE_MARKING_TYPE,
REPLACE(CONCAT(SUBSTRING(T1.`attendanceStatus`,1,1),SUBSTRING(LOWER(T1.`attendanceStatus`),2)),'_',' ') as STATUS,
(case when (T7.itemValue = 'Present' and T7.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T7.attendanceStatus, 1)), LCASE(SUBSTRING(T7.attendanceStatus, 2)))
     when (T7.itemValue = 'Absent' and T7.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T7.attendanceStatus, 1)), LCASE(SUBSTRING(T7.attendanceStatus, 2)))
    else CONCAT(T7.itemValue, '/', CONCAT(UCASE(LEFT(T7.attendanceStatus, 1)), LCASE(SUBSTRING(T7.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM `student_program_attendance_details` T1
INNER JOIN `student_program_attendance` T2 ON T1.`attendanceId` = T2.`id`
INNER JOIN `admission` T3 ON T3.`id` = T1.`admissionId`
INNER JOIN `students` T4 ON T4.`userId` = T3.`studentId`
INNER JOIN `persons` T5 ON T5.`id` = T4.`personId`
INNER JOIN `users` T14 ON T14.`id` = T4.`userId`
LEFT JOIN `salutations` T6 ON T5.`salutationId` = T6.`id`
LEFT JOIN `attendance_marking_type` AS T7 ON T7.`id` = T1.`attendanceMarkingTypeId`
WHERE T14.`id` IN (namedParams)
AND T2.`id` = (
select max(attendanceId) from `student_program_attendance_details` T9
INNER JOIN `student_program_attendance` T10 ON T9.`attendanceId` = T10.`id`
INNER JOIN `admission` T11 ON T11.`id` = T9.`admissionId`
INNER JOIN `students` T12 ON T12.`userId` = T11.`studentId`
INNER JOIN `persons` T13 ON T13.`id` = T12.`personId`
INNER JOIN `users` T14 ON T14.`id` = T12.`userId`
WHERE T14.`id` IN (namedParams))", `jsonString` = '{
	"id": 1,
	"searchResultViewColumns": [{
			"id": 1,
			"value": "id",
			"resultKey": "ID",
			"displayCode": "",
			"displayOrder": 0
		},
		{
			"id": 2,
			"value": "firstName",
			"resultKey": "FIRST_NAME",
			"displayCode": "",
			"displayOrder": 1
		},
		{
			"id": 3,
			"value": "middleName",
			"resultKey": "MIDDLE_NAME",
			"displayCode": "",
			"displayOrder": 2
		},
		{
			"id": 4,
			"value": "lastName",
			"resultKey": "LAST_NAME",
			"displayCode": "",
			"displayOrder": 3
		},
		{
			"id": 5,
			"value": "salutaion",
			"resultKey": "SALUTATION",
			"displayCode": "",
			"displayOrder": 4
		},
		{
			"id": 6,
			"value": "dateOfAttendance",
			"resultKey": "DATE_OF_ATTENDANCE",
			"displayCode": "",
			"displayOrder": 5
		},
		{
			"id": 7,
			"value": "emailId",
			"resultKey": "EMAIL_ID",
			"displayCode": "",
			"displayOrder": 6
		},
		{
			"id": 8,
			"value": "mobileNumber",
			"resultKey": "MOBILE_NO",
			"displayCode": "",
			"displayOrder": 7
		},
		{
			"id": 9,
			"value": "attendanceStatus",
			"resultKey": "STATUS",
			"displayCode": "",
			"displayOrder": 8
		},
		{
			"id": 10,
			"value": "ATTENDANCE_STATUS",
			"resultKey": "ATTENDANCE_STATUS",
			"displayCode": "",
			"displayOrder": 9
		}
	]
}' where `dataProviderId` = @dtproviderId;




SET SQL_SAFE_UPDATES = 1;