DROP procedure IF EXISTS `delete_student`;
DELIMITER $$
CREATE PROCEDURE `delete_student`(studentIds varchar(21844))
BEGIN

SET SQL_SAFE_UPDATES=0;
SET FOREIGN_KEY_CHECKS=0;
SET SESSION group_concat_max_len = 1000000;

SELECT group_concat(distinct students.personId) into @personID from students 
where FIND_IN_SET(students.userId,studentIds);

SELECT group_concat(distinct admission.id) into @admissionID from admission 
where FIND_IN_SET(admission.studentId,studentIds);

SELECT group_concat(distinct admission.applicationAdmissionId) into @applicationAdmDetailsId from admission 
where FIND_IN_SET(admission.studentId,studentIds);

SELECT group_concat(distinct user_academy_locations.id) into @userALID 
from user_academy_locations where 
FIND_IN_SET(user_academy_locations.userId,studentIds);


DELETE FROM prog_batch_course_details where FIND_IN_SET(prog_batch_course_details.admissionId,@admissionID);

DELETE FROM student_course_enrollment where FIND_IN_SET(student_course_enrollment.admissionId,@admissionID);

DELETE from promotion where fromRecordId in (
SELECT id FROM program_batch_students where FIND_IN_SET(program_batch_students.admissionId,@admissionID));

DELETE FROM program_batch_students where FIND_IN_SET(program_batch_students.admissionId,@admissionID);

delete from marksheet_job_details where FIND_IN_SET(marksheet_job_details.admissionId,@admissionID);

delete from marksheet where FIND_IN_SET(marksheet.admissionId,@admissionID);

delete from examination_repetition where FIND_IN_SET(examination_repetition.admissionId,@admissionID);

delete from evaluation_program_rank where FIND_IN_SET(evaluation_program_rank.admissionId,@admissionID);

delete from evaluation_period_rank where FIND_IN_SET(evaluation_period_rank.admissionId,@admissionID);

delete from evaluation_plan_rank where FIND_IN_SET(evaluation_plan_rank.admissionId,@admissionID);

delete from evaluation_plan_level_one_rank where FIND_IN_SET(evaluation_plan_level_one_rank.admissionId,@admissionID);

delete from evaluation_plan_level_two_rank where FIND_IN_SET(evaluation_plan_level_two_rank.admissionId,@admissionID);

delete from evaluation_sequence_rank where FIND_IN_SET(evaluation_sequence_rank.admissionId,@admissionID);

delete from examination_result_history where FIND_IN_SET(examination_result_history.admissionId,@admissionID);

delete from examination_result where FIND_IN_SET(examination_result.admissionId,@admissionID);

delete from evaluation_group_applicant_document where FIND_IN_SET(evaluation_group_applicant_document.admissionId,@admissionID);

delete from evaluation_group_applicant where FIND_IN_SET(evaluation_group_applicant.admissionId,@admissionID);

delete from evaluation_plan_students where FIND_IN_SET(evaluation_plan_students.admissionId,@admissionID);

delete from evaluation_student_remark where FIND_IN_SET(evaluation_student_remark.admissionId,@admissionID);

delete from exam_timeslot where FIND_IN_SET(exam_timeslot.admissionId,@admissionID);

delete from evaluation_student_remark where FIND_IN_SET(evaluation_student_remark.admissionId,@admissionID);

delete from exam_result_event_students where FIND_IN_SET(exam_result_event_students.admissionId,@admissionID);

DELETE from student_promotions where completionId in (
select completionId FROM completions where FIND_IN_SET(completions.admissionId,@admissionID));

DELETE FROM completions where FIND_IN_SET(completions.admissionId,@admissionID);

DELETE FROM student_program_attendance_details where FIND_IN_SET(student_program_attendance_details.admissionId,@admissionID);

DELETE FROM group_hw_assignment_documents where groupHomeworkAssignmentId in (
SELECT id FROM group_hw_assignment where FIND_IN_SET(group_hw_assignment.admissionId,@admissionID));

DELETE FROM group_hw_assignment where FIND_IN_SET(group_hw_assignment.admissionId,@admissionID);

DELETE FROM student_attendance_dashboard_student_wise where FIND_IN_SET(student_attendance_dashboard_student_wise.admissionId,@admissionID);

DELETE FROM class_teacher_student_remarks where FIND_IN_SET(class_teacher_student_remarks.admissionId,@admissionID);

DELETE FROM student_academic_topics where FIND_IN_SET(student_academic_topics.admissionId,@admissionID);

DELETE FROM admission_student_documents where FIND_IN_SET(admission_student_documents.admissionId,@admissionID);

DELETE FROM student_course_attendance_details where FIND_IN_SET(student_course_attendance_details.admissionId,@admissionID);

DELETE FROM admission where FIND_IN_SET(admission.id,@admissionID);

DELETE from fee_adjustment_details where billFeeRuleStageId in (
select id FROM bill_fee_plan_rule_stage where billId in (
select id FROM bill_header where FIND_IN_SET(bill_header.userId,studentIds) OR FIND_IN_SET(bill_header.studentId,studentIds)));

DELETE FROM bill_dependant_details where billFeePlanRuleStageId in (
SELECT id FROM bill_fee_plan_rule_stage where billId in (
select id FROM bill_header where FIND_IN_SET(bill_header.userId,studentIds) OR FIND_IN_SET(bill_header.studentId,studentIds)));

DELETE FROM bill_fee_plan_rule_stage where billId in (
select id FROM bill_header where FIND_IN_SET(bill_header.userId,studentIds) OR FIND_IN_SET(bill_header.studentId,studentIds));

DELETE FROM bill_header where FIND_IN_SET(bill_header.userId,studentIds) OR FIND_IN_SET(bill_header.studentId,studentIds);

DELETE FROM bill_fee_plan_rule_stage_tracking where billId in (
SELECT id FROM bill_header_tracking where FIND_IN_SET(bill_header_tracking.userId,studentIds) OR FIND_IN_SET(bill_header_tracking.studentId,studentIds));

DELETE FROM bill_header_tracking where FIND_IN_SET(bill_header_tracking.userId,studentIds) OR FIND_IN_SET(bill_header_tracking.studentId,studentIds);

DELETE FROM user_acad_loc_roles where FIND_IN_SET(user_acad_loc_roles.userAcadLocationId,@userALID);

DELETE FROM user_academy_locations where FIND_IN_SET(user_academy_locations.userId,studentIds);

DELETE FROM student_documents where FIND_IN_SET(student_documents.studentId,studentIds);

DELETE FROM fee_adjustment_master where receiptHeaderId in (
select id FROM receipt_header where FIND_IN_SET(receipt_header.studentId,studentIds));

DELETE FROM receipt_payment_instrument where receiptHeaderId in (
SELECT id FROM receipt_header where FIND_IN_SET(receipt_header.studentId,studentIds));

DELETE FROM receipt_header where FIND_IN_SET(receipt_header.studentId,studentIds);

DELETE FROM fee_plan_persons_covered where FIND_IN_SET(fee_plan_persons_covered.studentId,studentIds);

DELETE FROM installment_details where feeRelatedRequestDetailId in (
SELECT id FROM fee_related_request_details where FIND_IN_SET(fee_related_request_details.studentId,studentIds));

DELETE FROM fee_related_request_details where FIND_IN_SET(fee_related_request_details.studentId,studentIds);

DELETE FROM student_other_information_cd where studentOtherInfoId in (
SELECT id FROM student_other_information where FIND_IN_SET(student_other_information.studentId,studentIds));

DELETE FROM student_other_information where FIND_IN_SET(student_other_information.studentId,studentIds);

DELETE FROM students where FIND_IN_SET(students.userId,studentIds);

DELETE FROM leave_report where FIND_IN_SET(leave_report.userId,studentIds);

DELETE from usertries where  FIND_IN_SET(usertries.userId,studentIds);

DELETE FROM users_system_usage_log where FIND_IN_SET(users_system_usage_log.userId,studentIds);

DELETE FROM user_login_history where FIND_IN_SET(user_login_history.userId,studentIds);

DELETE FROM program_xfer_request_details where serviceRequestId in (
select id FROM service_requests where FIND_IN_SET(service_requests.requester,studentIds));

DELETE FROM followup_details where serviceRequestId in (select id FROM service_requests where FIND_IN_SET(service_requests.requester,studentIds));

DELETE FROM service_requests where FIND_IN_SET(service_requests.requester,studentIds);

DELETE FROM academia_koha_sync where FIND_IN_SET(academia_koha_sync.userId,studentIds);

DELETE FROM request_status where FIND_IN_SET(request_status.lastUpdatedBy,studentIds);

DELETE FROM users where FIND_IN_SET(users.id,studentIds);

DELETE p,u  FROM users u 
inner join parents p on u.id=p.userId 
inner join person_relationships pr on pr.relatedPersonId=p.personId
where FIND_IN_SET(pr.personId,@personID);

DELETE FROM person_relationships where FIND_IN_SET(person_relationships.personId,@personID);

DELETE FROM person_addresses where FIND_IN_SET(person_addresses.personId,@personID);

DELETE FROM persons where FIND_IN_SET(persons.id,@personID);

DELETE FROM user_password_history where FIND_IN_SET(user_password_history.userId,studentIds);


-- Applicant Data Deletion 
select  group_concat(distinct ap.applicationId)  into @applicationIds
from admission a inner join application_program ap on a.applicationProgramId=ap.id
where FIND_IN_SET(a.studentId,studentIds);

select group_concat(distinct application.applicantPersonId)  into @ApplicantPersonIds
from application where FIND_IN_SET(application.id,@applicationIds);

select group_concat(distinct application_program.id)  into @ApplicantProgramIds
from application_program where FIND_IN_SET(application_program.applicationId,@applicationIds);

select group_concat(distinct application_prog_stage.id)  into @ApplicantProgramStageIds
from application_prog_stage where FIND_IN_SET(application_prog_stage.applicationProgramId, @ApplicantProgramIds);



-- Start Delete Applicant Selection stage Related Data
DELETE from application_prog_stage_status where  
FIND_IN_SET(application_prog_stage_status.applicationProgramStageId, @ApplicantProgramStageIds);
 
DELETE from application_prog_stage_marks where 
FIND_IN_SET(application_prog_stage_marks.applicationProgramStageId, @ApplicantProgramStageIds);

-- Conditional admission documents
DELETE acdl,ed,d from application_condition_doc_log acdl inner join application_condition_log acl
on acdl.applicationConditionLogId=acl.id inner join documents d on d.id=acdl.documentId
inner join extended_documents ed on ed.documentId=d.id
where FIND_IN_SET(acl.applicationId,@applicationIds);

DELETE acl,ac FROM application_condition_log acl inner join application_condition ac
on acl.applicationConditionId=ac.id
where FIND_IN_SET(acl.applicationId,@applicationIds);

-- End Delete Applicant Selection stage Related Data

-- Start Delete Applicant Fees related Data

DELETE afpd, afd FROM application_fee_plan_details afpd inner join application_fee_details afd
on afpd.applicationFeeDetailId=afd.id where
 FIND_IN_SET(afd.applicationId,@applicationIds);

-- RECEIPT Adjustment Details  
DELETE  fad, fdm FROM fee_adjustment_details fad inner join fee_adjustment_master fdm
on fdm.id=fad.adjustmentMasterId
inner join receipt_header rh on rh.id=fdm.receiptHeaderId
where FIND_IN_SET(rh.applicantId,@applicationIds);

DELETE FROM receipt_payment_instrument where receiptHeaderId in (
select id FROM receipt_header where
FIND_IN_SET(receipt_header.applicantId,@applicationIds));

--  RECEIPT Voucher
DELETE vd,rv,v from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join receipt_voucher rv on v.id=rv.voucherId
inner join receipt_header rh on rh.id=rv.receiptHeaderId
where FIND_IN_SET(rh.applicantId,@applicationIds);

-- RECEIPT 
DELETE FROM receipt_header where FIND_IN_SET(receipt_header.applicantId,@applicationIds);

-- PAYMENT Voucher 
DELETE vd,pv,v,ph from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join payment_voucher pv on v.id=pv.voucherId
inner join payment_header ph on ph.id=pv.paymentHeaderId
where FIND_IN_SET(ph.applicantId,@applicationIds);

-- BILL Voucher
DELETE vd,bv,v,bh from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join bill_voucher bv on v.id=bv.voucherId
inner join bill_header bh on bh.id=bv.billId
where FIND_IN_SET(bh.applicantId,@applicationIds);

-- BILL Adjustment Details  
DELETE  fad, fdm FROM fee_adjustment_details fad inner join fee_adjustment_master fdm
on fdm.id=fad.adjustmentMasterId
inner join bill_header bh on bh.id=fdm.billHeaderId
where FIND_IN_SET(bh.applicantId,@applicationIds);

-- Applicant Discount 
DELETE FROM applicant_student_discount_master 
where FIND_IN_SET(applicant_student_discount_master.applicantId,@applicationIds);

 -- Bill Discount details
DELETE bdd FROM bill_fee_plan_rule_stage bfprs inner join bill_header bh on bfprs.billId=bh.id
inner join bill_discount_details bdd on bdd.billFeePlanRuleStageId=bfprs.id
where FIND_IN_SET(bh.applicantId,@applicationIds);

-- Bill And Fee plan rule stage details
DELETE bfprs FROM bill_fee_plan_rule_stage bfprs inner join bill_header bh on bfprs.billId=bh.id
where FIND_IN_SET(bh.applicantId,@applicationIds);

-- BILL 
DELETE FROM bill_header where FIND_IN_SET(bill_header.applicantId,@applicationIds);

DELETE from application_prog_stage where
FIND_IN_SET(application_prog_stage.id, @ApplicantProgramStageIds);

-- END Delete Applicant Fees related Data

-- Start Delete Applicant other details Data

-- Applicant Documents
DELETE ard,ed,d from application_required_documents ard 
inner join documents d on d.id=ard.documentId
inner join extended_documents ed on ed.documentId=d.id
where FIND_IN_SET(ard.applicationId,@applicationIds);

DELETE FROM application_required_documents where
FIND_IN_SET(application_required_documents.applicationId,@applicationIds);
--

DELETE FROM applicant_address where 
FIND_IN_SET(applicant_address.applicantPersonId, @ApplicantPersonIds);

DELETE FROM fee_payer_detail where  
FIND_IN_SET(fee_payer_detail.applicantPersonId, @ApplicantPersonIds);

DELETE  e1,e2 from external_user_association e1 inner join 
external_users e2 on e1.externalUserId=e2.id where
FIND_IN_SET(e1.applicationId ,@applicationIds);

DELETE FROM application_admission_detail where 
FIND_IN_SET(application_admission_detail.applicationProgramId, @ApplicantProgramIds);

DELETE from application_timeline where 
FIND_IN_SET(application_timeline.applicationId ,@applicationIds);

DELETE from application_program where FIND_IN_SET(application_program.applicationId ,@applicationIds);

DELETE apr,ap  FROM applicant_person_relationships  apr inner join applicant_person ap on 
apr.relatedApplicantPersonId=ap.id
where FIND_IN_SET(apr.applicantPersonId, @ApplicantPersonIds);

DELETE  a , af from application a inner join application_form af 
on a.applicationFormId =af.id where FIND_IN_SET(a.id ,@applicationIds);

DELETE FROM application where FIND_IN_SET(application.id ,@applicationIds);

-- END Delete Applicant other details Data
SET SQL_SAFE_UPDATES=1;
SET FOREIGN_KEY_CHECKS=1;
	
END$$

DELIMITER ;

