-- Ahdoc msg for committee

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOMEWORK_ASSIGNMENT_STUDENT_ADHOC', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_STUDENT_ADHOC');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'HOMEWORK_ASSIGNMENT_STUDENT_ADHOC');

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_STUDENT_ADHOC');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,'SELECT 
    T1.id AS ID,
    T4.firstName AS FIRST_NAME,
    T4.lastName AS LAST_NAME,
    T4.printName AS PRINT_NAME,
    T4.emailId AS EMAIL_ID,
    T4.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T4.mobileNumber AS MOBILE_NO,
    T4.mobileCountryCode AS MOBILE_CODE,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    T6.assignmentName AS ASSIGNMENT_NAME,
    T8.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T8.courseCode AS COURSE_CODE,
    T7.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
    DATE_FORMAT(NOW(), "%Y-%m-%d %H:%i:%s") AS CURRENT_DATE_TIME
   --  group_concat(distinct f.deviceTokenId) AS DEVICE_ID
FROM
    group_hw_assignment T1
        LEFT JOIN
    admission AS T2 ON T2.id = T1.admissionId
        LEFT JOIN
    students AS T3 ON T3.userId = T2.studentId
        LEFT JOIN
    persons AS T4 ON T4.id = T3.personId
        LEFT JOIN
    academy_location T5 ON T5.id = T2.academyLocationId
        LEFT JOIN
    course_hw_asignment T6 ON T6.id = T1.hwAssignmentId
        LEFT JOIN
    course_variants T7 ON T7.id = T6.courseVariantId
        LEFT JOIN
    courses T8 ON T8.id = T7.courseId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
WHERE
    T1.id IN (namedParams)','{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "assignmentName",
            "resultKey": "ASSIGNMENT_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 8,
            "value": "nameToBePrinted",
            "resultKey": "COURSE_NAME_TO_BE_PRINTED",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "courseCode",
            "resultKey": "COURSE_CODE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "courseVariantCode",
            "resultKey": "COURSE_VARIANT_CODE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "courseVariantDescription",
            "resultKey": "COURSE_VARIANT_DESCRIPTION",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "CURRENT_DATE_TIME",
            "resultKey": "CURRENT_DATE_TIME",
            "displayCode": "",
            "displayOrder": 11
        }
    ]}');

-- set predefine msg template for committeee

SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='HOMEWORK_ASSIGNMENT_STUDENT_ADHOC');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`,`approvalRequired`,`approverId`,`whetherStaticMsg`,`status`,`availableForAdhocMsg`,`academyLocationId`,`authorName`,`authorId`) 
VALUES (@msgTemplateConfigId+1,'Homework Assignment Allocation',64,NULL,@msgrecipienttypeId,4,NULL,NULL,'Homework Assignment Allocation',NULL,0,NULL,0,'APPROVED',1,1,'System Admin',1);



INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Take Home Assignment','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Take home assignment has been given to you for $recipientData["COURSE_CODE"]/$recipientData["COURSE_NAME_TO_BE_PRINTED"]. The submission
deadline is $recipientData["CURRENT_DATE_TIME"]. Please log in to Student Portal for more details.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Take Home Assignment','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Take home assignment has been given to you for $recipientData["COURSE_CODE"]/$recipientData["COURSE_NAME_TO_BE_PRINTED"]. The submission
deadline is $recipientData["CURRENT_DATE_TIME"]. Please log in to Student Portal for more details.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


