set sql_safe_updates=0;


Update application_prog_stage
INNER JOIN
(SELECT 
    eff.id,eff.applicationProgramId,eff.includePrevsStagePerformance,
    round((CASE
        WHEN eff.includePrevsStagePerformance = 0 THEN effectiveWeightage_with_no_prev_stage
        ELSE effectiveWeightage_with_prev_stage
    END),2) AS effectiveWeightage
FROM
    (SELECT asp.applicationProgramId,
            asp.id,wt.sumOfWeightage,(100 - wt.sumOfWeightage) as CurrentStageWeightage,
            spsep.includePrevsStagePerformance,
    
            (asp.stageMarkWithWeightage) AS effectiveWeightage_with_no_prev_stage,
           
            (sum(((prev_asp.stageMarkWithWeightage * sspw.weightage) / 100)) + ((asp.stageMarkWithWeightage * (100 - wt.sumOfWeightage)) / 100)) AS effectiveWeightage_with_prev_stage
    FROM
        application_prog_stage AS asp
    INNER JOIN program_slctn_process_stages AS psps ON asp.programSelectionProcessStageId = psps.id
    INNER JOIN slctn_process_stage_eval_param AS spsep ON psps.selectionProcessStageId = spsep.selectionProcessStageId
    LEFT JOIN slctn_stage_prvs_weightage AS sspw ON spsep.id = sspw.stageEvalParamId
    INNER JOIN (SELECT 
        asp.id, asp.applicationProgramId, SUM(sspw.weightage) AS sumOfWeightage
    FROM
        application_prog_stage AS asp
    INNER JOIN program_slctn_process_stages AS psps ON asp.programSelectionProcessStageId = psps.id
    INNER JOIN slctn_process_stage_eval_param AS spsep ON psps.selectionProcessStageId = spsep.selectionProcessStageId
    LEFT JOIN slctn_stage_prvs_weightage AS sspw ON spsep.id = sspw.stageEvalParamId
    
    GROUP BY asp.id, applicationProgramId) AS wt ON asp.id = wt.id and asp.applicationProgramId=wt.applicationProgramId
    LEFT JOIN program_slctn_process_stages AS prev_psps ON sspw.previousStageId = prev_psps.selectionProcessStageId
    LEFT JOIN application_prog_stage AS prev_asp ON prev_psps.id = prev_asp.programSelectionProcessStageId 
              and prev_asp.applicationProgramId=asp.applicationProgramId
    
    GROUP BY asp.id) AS eff
) as ef on application_prog_stage.id=ef.id
set application_prog_stage.effectiveStageMarkWithWeightage=ef.effectiveWeightage;

set sql_safe_updates=1;