


CREATE TABLE `course_variant_type_mapping` (
 `id` bigint(20) NOT NULL AUTO_INCREMENT,
 `typeId` bigint(20) NOT NULL,
 `evaluationTypeCourseId` bigint(20) DEFAULT NULL,
 `evaluationTypeProgramId` bigint(20) DEFAULT NULL,
 `status` varchar(45) NOT NULL DEFAULT 'PENDING',
 `lastUpdatedBy` bigint(20) NOT NULL,
 `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 UNIQUE KEY `type_mapping_unique_typeCourse` (`typeId`,`evaluationTypeCourseId`),
 UNIQUE KEY `type_mapping_unique_typeProgram` (`typeId`,`evaluationTypeProgramId`),
 KEY `type_mapping_typeId` (`typeId`),
 KEY `type_mapping_evaluationTypeCourseId` (`evaluationTypeCourseId`),
 KEY `type_mapping_evaluationTypeProgramId` (`evaluationTypeProgramId`),
 KEY `type_mapping_lastUpdatedBy` (`lastUpdatedBy`),
 CONSTRAINT `type_mapping_evaluationTypeCourseId` FOREIGN KEY (`evaluationTypeCourseId`) REFERENCES `evaluation_type_course` (`id`),
 CONSTRAINT `type_mapping_evaluationTypeProgramId` FOREIGN KEY (`evaluationTypeProgramId`) REFERENCES `evaluation_type_program` (`id`),
 CONSTRAINT `type_mapping_eventId` FOREIGN KEY (`typeId`) REFERENCES `evaluation_plan_level_one` (`id`),
 CONSTRAINT `type_mapping_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



-- 1601
INSERT INTO course_variant_type_mapping (typeId,evaluationTypeCourseId,evaluationTypeProgramId,status,lastUpdatedBy,lastUpdate)
SELECT distinct
    type.id AS typeId, evalTypeCourse.id AS EvalTypeCourseId, null as EvalTypeProgId,  type.evalPlanLevelOneStatus, 1, now()
FROM
    eval_seq_detail AS event
        INNER JOIN
    evaluation_sequence AS method ON event.evalSequenceId = method.id
        INNER JOIN
    evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
        INNER JOIN
    evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
        INNER JOIN
    evaluation_plan AS plan ON type.evaluationPlanId = plan.id
        INNER JOIN
    evaluation_type_course AS evalTypeCourse ON plan.id = evalTypeCourse.evaluationPlanId
    order by plan.id,  type.id , evalTypeCourse.id;
    
-- 213   
INSERT INTO course_variant_type_mapping (typeId,evaluationTypeCourseId,evaluationTypeProgramId,status,lastUpdatedBy,lastUpdate)
SELECT distinct	
    type.id AS typeId, null as EvalTypeCourseId,  evalTypeProg.id as EvalTypeProgId, type.evalPlanLevelOneStatus, 1, now()
FROM
    eval_seq_detail AS event
        INNER JOIN
    evaluation_sequence AS method ON event.evalSequenceId = method.id
        INNER JOIN
    evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
        INNER JOIN
    evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
        INNER JOIN
    evaluation_plan AS plan ON type.evaluationPlanId = plan.id
        INNER JOIN
    evaluation_type_program AS evalTypeProg ON plan.id = evalTypeProg.evaluationPlanId
    
    order by plan.id,  type.id , evalTypeProg.id;
    
-- ==================================================================

-- course_variant_subType_mapping

CREATE TABLE `course_variant_subType_mapping` (
 `id` bigint(20) NOT NULL AUTO_INCREMENT,
 `subTypeId` bigint(20) NOT NULL,
 `evaluationTypeCourseId` bigint(20) DEFAULT NULL,
 `evaluationTypeProgramId` bigint(20) DEFAULT NULL,
 `status` varchar(45) NOT NULL DEFAULT 'PENDING',
 `lastUpdatedBy` bigint(20) NOT NULL,
 `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 UNIQUE KEY `subType_mapping_unique_typeCourse` (`subTypeId`,`evaluationTypeCourseId`),
 UNIQUE KEY `subType_mapping_unique_typeProgram` (`subTypeId`,`evaluationTypeProgramId`),
 KEY `subType_mapping_subTypeId` (`subTypeId`),
 KEY `subType_mapping_evaluationTypeCourseId` (`evaluationTypeCourseId`),
 KEY `subType_mapping_evaluationTypeProgramId` (`evaluationTypeProgramId`),
 KEY `subType_mapping_lastUpdatedBy` (`lastUpdatedBy`),
 CONSTRAINT `subType_mapping_evaluationTypeCourseId` FOREIGN KEY (`evaluationTypeCourseId`) REFERENCES `evaluation_type_course` (`id`),
 CONSTRAINT `subType_mapping_evaluationTypeProgramId` FOREIGN KEY (`evaluationTypeProgramId`) REFERENCES `evaluation_type_program` (`id`),
 CONSTRAINT `subType_mapping_subTypeId` FOREIGN KEY (`subTypeId`) REFERENCES `evaluation_plan_level_two` (`id`),
 CONSTRAINT `subType_mapping_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



-- 2710
INSERT INTO course_variant_subType_mapping (subTypeId,evaluationTypeCourseId,evaluationTypeProgramId,status,lastUpdatedBy,lastUpdate)
SELECT distinct
    subType.id AS subTypeId, evalTypeCourse.id AS EvalTypeCourseId, null as EvalTypeProgId,  subType.evaluationPlan2LevelStatus, 1, now()
FROM
    eval_seq_detail AS event
        INNER JOIN
    evaluation_sequence AS method ON event.evalSequenceId = method.id
        INNER JOIN
    evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
        INNER JOIN
    evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
        INNER JOIN
    evaluation_plan AS plan ON type.evaluationPlanId = plan.id
        INNER JOIN
    evaluation_type_course AS evalTypeCourse ON plan.id = evalTypeCourse.evaluationPlanId
    order by plan.id,  type.id , evalTypeCourse.id;
    
-- 282    
INSERT INTO course_variant_subType_mapping (subTypeId,evaluationTypeCourseId,evaluationTypeProgramId,status,lastUpdatedBy,lastUpdate)
SELECT 	distinct
    subType.id AS subTypeId, null as EvalTypeCourseId,  evalTypeProg.id as EvalTypeProgId, subType.evaluationPlan2LevelStatus, 1, now()
FROM
    eval_seq_detail AS event
        INNER JOIN
    evaluation_sequence AS method ON event.evalSequenceId = method.id
        INNER JOIN
    evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
        INNER JOIN
    evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
        INNER JOIN
    evaluation_plan AS plan ON type.evaluationPlanId = plan.id
        INNER JOIN
    evaluation_type_program AS evalTypeProg ON plan.id = evalTypeProg.evaluationPlanId
    
    order by plan.id,  type.id , evalTypeProg.id;
    
-- ==================================================================================

-- course_variant_method_mapping

CREATE TABLE `course_variant_method_mapping` (
 `id` bigint(20) NOT NULL AUTO_INCREMENT,
 `methodId` bigint(20) NOT NULL,
 `evaluationTypeCourseId` bigint(20) DEFAULT NULL,
 `evaluationTypeProgramId` bigint(20) DEFAULT NULL,
 `status` varchar(45) NOT NULL DEFAULT 'PENDING',
 `lastUpdatedBy` bigint(20) NOT NULL,
 `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 UNIQUE KEY `method_mapping_unique_typeCourse` (`methodId`,`evaluationTypeCourseId`),
 UNIQUE KEY `method_mapping_unique_typeProgram` (`methodId`,`evaluationTypeProgramId`),
 KEY `method_mapping_subTypeId` (`methodId`),
 KEY `method_mapping_evaluationTypeCourseId` (`evaluationTypeCourseId`),
 KEY `method_mapping_evaluationTypeProgramId` (`evaluationTypeProgramId`),
 KEY `method_mapping_lastUpdatedBy` (`lastUpdatedBy`),
 CONSTRAINT `method_mapping_evaluationTypeCourseId` FOREIGN KEY (`evaluationTypeCourseId`) REFERENCES `evaluation_type_course` (`id`),
 CONSTRAINT `method_mapping_evaluationTypeProgramId` FOREIGN KEY (`evaluationTypeProgramId`) REFERENCES `evaluation_type_program` (`id`),
 CONSTRAINT `method_mapping_methodId` FOREIGN KEY (`methodId`) REFERENCES `evaluation_sequence` (`id`),
 CONSTRAINT `method_mapping_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



-- 4036
INSERT INTO course_variant_method_mapping (methodId,evaluationTypeCourseId,evaluationTypeProgramId,status,lastUpdatedBy,lastUpdate)
SELECT distinct
    method.id AS methodId, evalTypeCourse.id AS EvalTypeCourseId, null as EvalTypeProgId,  method.evalSequenceStatus, 1, now()
FROM
    eval_seq_detail AS event
        INNER JOIN
    evaluation_sequence AS method ON event.evalSequenceId = method.id
        INNER JOIN
    evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
        INNER JOIN
    evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
        INNER JOIN
    evaluation_plan AS plan ON type.evaluationPlanId = plan.id
        INNER JOIN
    evaluation_type_course AS evalTypeCourse ON plan.id = evalTypeCourse.evaluationPlanId
    order by plan.id,  type.id , evalTypeCourse.id;
    
-- 735    
INSERT INTO course_variant_method_mapping (methodId,evaluationTypeCourseId,evaluationTypeProgramId,status,lastUpdatedBy,lastUpdate)
SELECT 	distinct
    method.id AS methodId, null as EvalTypeCourseId,  evalTypeProg.id as EvalTypeProgId, method.evalSequenceStatus, 1, now()
FROM
    eval_seq_detail AS event
        INNER JOIN
    evaluation_sequence AS method ON event.evalSequenceId = method.id
        INNER JOIN
    evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
        INNER JOIN
    evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
        INNER JOIN
    evaluation_plan AS plan ON type.evaluationPlanId = plan.id
        INNER JOIN
    evaluation_type_program AS evalTypeProg ON plan.id = evalTypeProg.evaluationPlanId
    
    order by plan.id,  type.id , evalTypeProg.id;
    