DELIMITER $$

DROP TRIGGER IF EXISTS evaluation_student_remark_marksheet_trigger$$

CREATE TRIGGER evaluation_student_remark_marksheet_trigger 
 AFTER UPDATE ON evaluation_student_remark 
 FOR EACH ROW 
BEGIN
IF NEW.remark <=> OLD.remark || NEW.remark <> OLD.remark || NEW.remark IS NULL || (OLD.remark IS NULL && NEW.remark IS NOT NULL) || 
   NEW.genericRemark <=> OLD.genericRemark || NEW.genericRemark <> OLD.genericRemark || NEW.genericRemark IS NULL || (OLD.genericRemark IS NULL && NEW.genericRemark IS NOT NULL)
THEN
	set sql_safe_updates=0;

		-- Type Level Subject Remark
		IF(OLD.courseVariantId IS NOT NULL && OLD.evalPlanLevelOneId IS NOT NULL) then
			if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and NEW.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId 
				and marksheet.evaluationPlanLevelTwoId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `genericRemark`, `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id, admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, type_plan.id, type_plan.evaluationPlanNumber,type.id,type.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, remark.genericRemark,type.printNameInMarksheet,type_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
				and marksheet.evaluationPlanLevelOneId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`,  `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id, admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, type_plan.id, type_plan.evaluationPlanNumber,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, null,type_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
    end if;
    else
		UPDATE marksheet set remark=NEW.remark, genericRemark=NEW.genericRemark  where courseVariantId=OLD.courseVariantId
		and evaluationPlanLevelOneId=OLD.evalPlanLevelOneId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelTwoId IS NULL;
	end if;
		-- Type Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalPlanLevelOneId IS NOT NULL) THEN
			if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId is null and marksheet.courseVariantId is null
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and NEW.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId 
				and marksheet.evaluationPlanLevelTwoId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `remark`, `genericRemark`, `levelOnePrintName`, `planPrintName`)
	select admission.id, admission.code, users.id, users.printName, type_plan.id, type_plan.evaluationPlanNumber,type.id,type.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, remark.genericRemark,type.printNameInMarksheet,type_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId is null and marksheet.courseVariantId is null
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
				and marksheet.evaluationPlanLevelOneId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `levelOnePrintName`, `planPrintName`)
    select admission.id, admission.code, users.id, users.printName, type_plan.id, type_plan.evaluationPlanNumber,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, null,type_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
    end if;
    else

		UPDATE marksheet set remark=NEW.remark, genericRemark=NEW.genericRemark  where courseVariantId is null
		and evaluationPlanLevelOneId=OLD.evalPlanLevelOneId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelTwoId IS NULL;
	end if;
		
		-- Sub Type Level Subject Remark
		ELSEIF (OLD.courseVariantId IS NOT NULL && OLD.evalPlanLevelTwoId IS NOT NULL) THEN
		if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and marksheet.evaluationPlanLevelTwoId = NEW.evalPlanLevelTwoId
            and marksheet.evaluationPlanThreeId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `genericRemark`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,subType.id,subType.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, remark.genericRemark, subType_type.printNameInMarksheet,subType.printNameInMarksheet,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    if(
			select count(marksheet.id) 
			from marksheet 
            join evaluation_plan_level_two subType on subType.id = NEW.evalPlanLevelTwoId
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId and
			subType.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId
            and marksheet.evaluationPlanLevelTwoId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`,  `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id,  subType_type.printNameInMarksheet,null,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    end if;
     if(
			select count(marksheet.id) 
			from marksheet
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
            and marksheet.evaluationPlanLevelOneId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`,  `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,null,null,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id,  null,null,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
    end if;
     else       
		UPDATE marksheet set remark=NEW.remark, genericRemark=NEW.genericRemark  
        where evaluationPlanLevelTwoId=OLD.evalPlanLevelTwoId and courseVariantId=OLD.courseVariantId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanThreeId IS NULL;
end if;
		
		-- Sub Type Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalPlanLevelTwoId IS NOT NULL) THEN
		
		if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and marksheet.courseVariantId is null 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and marksheet.evaluationPlanLevelTwoId = NEW.evalPlanLevelTwoId
            and marksheet.evaluationPlanThreeId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `remark`, `genericRemark`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`)
	select admission.id,admission.code, users.id, users.printName, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,subType.id,subType.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, remark.genericRemark, subType_type.printNameInMarksheet,subType.printNameInMarksheet,subType_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, null, null, subType_type.printNameInMarksheet,null,subType_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, subType_plan.id, subType_plan.evaluationPlanNumber,null,null,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, null, null, null,null,subType_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
     else  
		UPDATE marksheet set remark=NEW.remark, genericRemark=NEW.genericRemark  
        where courseVariantId is null
		and evaluationPlanLevelTwoId=OLD.evalPlanLevelTwoId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanThreeId IS NULL;
end if;
		-- Method Level Subject Remark
		ELSEIF (OLD.courseVariantId IS NOT NULL && OLD.evalSequenceId IS NOT NULL) THEN
		
		 if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and marksheet.evaluationPlanThreeId = NEW.evalSequenceId
            and marksheet.evaluationPlanLevelFourId is null
			limit 1) = 0
			then 
  INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `evaluationPlanThreeId`, `evaluationLevelThree`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `genericRemark`, `levelOnePrintName`, `levelTwoPrintName`, `levelThreePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,method.id, sequence_header.sequenceName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, remark.genericRemark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,method.printNameInMarksheet, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    
		if(
			select count(marksheet.id) 
			from marksheet 
			join evaluation_sequence method on method.id=NEW.evalSequenceId
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and marksheet.evaluationPlanLevelTwoId = method.evalPlanLevelTwoId
            and marksheet.evaluationPlanThreeId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, 
`admissionCode`, 
`studentId`, 
`stdName`,
`courseName`, 
`courseCode`, 
`courseVariantId`, 
`courseVariant`, 
`evaluationPlanId`, 
`evaluationPlan`, 
`evaluationPlanLevelOneId`, 
`evaluationLevelOne`, 
`evaluationPlanLevelTwoId`, 
`evaluationLevelTwo`, 
`whetherShowInMarksheet`, 
`lastUpdatedBy`, 
`programId`, 
`programName`, 
`batchId`, 
`batchName`, 
`periodId`, 
`periodName`, 
`sectionId`, 
`sectionName`, 
 `levelOnePrintName`, 
`levelTwoPrintName`, 
`planPrintName`)

SELECT 
    admission.id,
    admission.code,
    users.id,
    users.printName,
    course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode,
    subType_plan.id,
    subType_plan.evaluationPlanNumber,
    subType_type.id,
    subType_type.levelName,
    subType.id,
    subType.levelName,
    TRUE,
    1,
    program.id,
    program.programNameToBePrint,
    batch.id,
    batch.printName,
    period.id,
    period.printName,
    section.id,
    section.alternateName,
    subType_type.printNameInMarksheet,
    subType.printNameInMarksheet,
    subType_plan.printNameInMarksheet
FROM
    evaluation_student_remark remark
    left join evaluation_sequence method on remark.evalSequenceId=method.id
        LEFT JOIN
    evaluation_plan_level_two subType ON method.evalPlanLevelTwoId = subType.id
        LEFT JOIN
    evaluation_plan_level_one subType_type ON subType.evalPlanLevelOneId = subType_type.id
        LEFT JOIN
    evaluation_plan subType_plan ON subType_type.evaluationPlanId = subType_plan.id
        JOIN
    admission ON remark.admissionId = admission.id
        JOIN
    users ON admission.studentId = users.id
    left join course_variants as cv on remark.courseVariantId=cv.id
	left join courses as course on cv.courseId=course.id
	left join courses as parentCourse on course.parentCourseId=parentCourse.id
        JOIN
    prog_batch_period_config period ON remark.periodId = period.id
        JOIN
    batches batch ON period.programBatchId = batch.id
        JOIN
    programs program ON batch.programId = program.id
        JOIN
    sections section ON remark.sectionId = section.id
WHERE
    remark.id =  NEW.id;
    
	end if;
    if(
			select count(marksheet.id) 
			from marksheet 
			join evaluation_sequence method on method.id=NEW.evalSequenceId
            join evaluation_plan_level_two subType on subType.id = method.evalPlanLevelTwoId
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId and
			 subType.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId
            and marksheet.evaluationPlanLevelTwoId IS NULL
			limit 1) = 0
			then 
           INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
SELECT 
    admission.id,
    admission.code,
    users.id,
    users.printName,
    course.nameToBePrinted,
    course.courseCode,
    cv.id,
    cv.courseVariantCode,
    type_plan.id,
    type_plan.evaluationPlanNumber,
    type.id,
    type.levelName,
    TRUE,
    1,
    program.id,
    program.programNameToBePrint,
    batch.id,
    batch.printName,
    period.id,
    period.printName,
    section.id,
    section.alternateName,
    course.id,
    type.printNameInMarksheet,
    type_plan.printNameInMarksheet,
    parentCourse.id,
    parentCourse.nameToBePrinted
FROM
    evaluation_student_remark remark
    left join evaluation_sequence method on remark.evalSequenceId=method.id
	   LEFT JOIN
    evaluation_plan_level_two subType ON method.evalPlanLevelTwoId = subType.id
        LEFT JOIN
    evaluation_plan_level_one type ON subType.evalPlanLevelOneId = type.id
        LEFT JOIN
    evaluation_plan type_plan ON type.evaluationPlanId = type_plan.id
        JOIN
    admission ON remark.admissionId = admission.id
        JOIN
    users ON admission.studentId = users.id
        LEFT JOIN
    course_variants cv ON remark.courseVariantId = cv.id
        LEFT JOIN
    courses course ON cv.courseId = course.id
        LEFT JOIN
    courses parentCourse ON course.parentCourseId = parentCourse.id
        JOIN
    prog_batch_period_config period ON remark.periodId = period.id
        JOIN
    batches batch ON period.programBatchId = batch.id
        JOIN
    programs program ON batch.programId = program.id
        JOIN
    sections section ON remark.sectionId = section.id
WHERE
    remark.id = NEW.id;
    
    end if;
     if(
			select count(marksheet.id) 
			from marksheet
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
            and marksheet.evaluationPlanLevelOneId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`,  `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,null,null,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id,  null,null,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    
     end if;
     else       
		UPDATE marksheet set remark=NEW.remark, genericRemark=NEW.genericRemark  where
		evaluationPlanThreeId=OLD.evalSequenceId and courseVariantId=OLD.courseVariantId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelFourId IS NULL;
end if;
		
		-- Method Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalSequenceId IS NOT NULL) THEN
		
		
		if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and marksheet.courseVariantId is null 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
            and marksheet.evaluationPlanThreeId = NEW.evalSequenceId
            and marksheet.evaluationPlanLevelFourId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `evaluationPlanThreeId`, `evaluationLevelThree`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `remark`, `genericRemark`, `levelOnePrintName`, `levelTwoPrintName`, `levelThreePrintName`, `planPrintName`)
	select admission.id,admission.code, users.id, users.printName, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,method.id, sequence_header.sequenceName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, remark.genericRemark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,method.printNameInMarksheet, method_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, remark.genericRemark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,null, method_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,null,null,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, remark.genericRemark, method_type.printNameInMarksheet,remark.remark, remark.genericRemark, method_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, method_plan.id, method_plan.evaluationPlanNumber,null,null,null,null,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, remark.genericRemark, null,null,null, method_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
     else       
		UPDATE marksheet set remark=NEW.remark, genericRemark=NEW.genericRemark  
        where courseVariantId is null
		and evaluationPlanThreeId=OLD.evalSequenceId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelFourId IS NULL;
	end if;	
		END IF;

	set sql_safe_updates=1;
END IF;
END$$
DELIMITER ;