CREATE TABLE `hr_emp_leave_credit_setting` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `staffId` BIGINT(20) NOT NULL,
  `hrLeaveCreditSettingId` BIGINT(20) NOT NULL,
  `parentHREmpLeaveCreditSettingId` BIGINT(20) NULL,
  `appliedOn` TIMESTAMP NOT NULL,
  `leaveCredited` DOUBLE NOT NULL,
  `leaveCarryForwarded` DOUBLE NULL,
  `leaveEncashed` DOUBLE NULL,
  `leaveLapsed` DOUBLE NULL,
  `nextCreditOn`DATE NULL,
  `nextLapseOn`DATE NULL,
  `nextEncashedOn`DATE NULL,
  `nextCarryForwardOn`DATE NULL,
  `isCurrent` BIT NOT NULL DEFAULT b'1',
  `lastUpdatedBy` BIGINT(20) NOT NULL DEFAULT '1',
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY (`staffId`,`hrLeaveCreditSettingId`),
  INDEX `fk_hr_emp_leave_credit_setting_staff_id_idx` (`staffId` ASC),
  INDEX `fk_hr_emp_leave_credit_setting_hr_lcs_id_idx` (`hrLeaveCreditSettingId` ASC),
  CONSTRAINT `fk_hr_emp_leave_credit_setting_staff_id`
    FOREIGN KEY (`staffId`)
    REFERENCES `staffs` (`userId`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_emp_leave_credit_setting_hr_lcs_id`
    FOREIGN KEY (`hrLeaveCreditSettingId`)
    REFERENCES `hr_leave_credit_setting` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

    
ALTER TABLE `hr_emp_leave_credit_setting` 
ADD INDEX `fk_hr_emp_leave_credit_setting_hr_elcs_id_idx` (`parentHREmpLeaveCreditSettingId` ASC);
ALTER TABLE `hr_emp_leave_credit_setting` 
ADD CONSTRAINT `fk_hr_emp_leave_credit_setting_hr_elcs_id`
FOREIGN KEY (`parentHREmpLeaveCreditSettingId`)
REFERENCES `hr_emp_leave_credit_setting` (`id`)
ON DELETE RESTRICT
ON UPDATE RESTRICT;
