
set sql_safe_updates=0;
CREATE OR REPLACE VIEW `grade_wise_report_view` AS SELECT DISTINCT
    al.displayName AS 'Brand',
    al.locationName AS 'Campus',
    al.id AS 'Academy_Location_id',
    pg.groupName AS 'School Phase',
    prgm.programNameToBePrint AS 'Grade',
    pc.categoryName AS 'Grade Category',
    batch.printName AS 'Intake',
    period.printName AS 'Period',
    section.sectionCode AS 'Class',
    fac.printName AS 'Class Teacher',
    usr.printName AS 'Student Name',
    usr.code AS 'Student Id',
    periodRank.obtainedMarks AS 'Period Level Marks',
    periodRank.sgpa AS 'SGPA',
    prgmRank.effectiveMarks AS 'Program Level Marks',
    prgmRank.obtainedCreditSum AS 'Credits Earned',
    prgmRank.CGPA AS 'CGPA',
    prgmRank.percentage AS 'percentage',
    avrg.marks AS 'Student Average',
    prgmRank.sectionRank AS 'Class Rank',
    prgmRank.programRank AS 'Grade Rank',
    prgmRank.status AS 'Result Status'
    
FROM
    evaluation_period_rank AS periodRank
        INNER JOIN
    admission AS admission ON admission.id = periodRank.admissionId
        INNER JOIN
    users AS usr ON usr.id = admission.studentId
        INNER JOIN
    academy_location AS al ON al.id = admission.academyLocationId
        INNER JOIN
    prog_batch_period_config AS period ON period.id = periodRank.periodId
        INNER JOIN
    batches AS batch ON batch.id = period.programBatchId
        INNER JOIN
    programs AS prgm ON prgm.id = batch.programId
        INNER JOIN
    evaluation_program_rank AS prgmRank ON prgmRank.batchId = batch.id and periodRank.admissionId = prgmRank.admissionId
        LEFT JOIN
    program_group AS pg ON pg.id = prgm.programGroupId
        LEFT JOIN
    program_category AS pc ON pc.id = prgm.programCategoryId
        LEFT OUTER JOIN
    exam_student_average AS avrg ON avrg.admissionId = admission.id
        AND avrg.periodId = period.id
        LEFT OUTER JOIN
    program_batch_students AS pbs ON pbs.admissionId = periodRank.admissionId
        AND ((pbs.programBatchId = prgmRank.batchId
        AND pbs.sectionId IS NOT NULL
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.isCurrentSection = TRUE))
        LEFT OUTER JOIN
    sections section ON pbs.sectionId = section.id
    LEFT JOIN
    users AS fac ON fac.id = section.facultyId;  
set sql_safe_updates=1;

