DELIMITER $$

DROP PROCEDURE IF EXISTS V20200106185920__InsertUITranslationForHorizontal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200106185920__InsertUITranslationForHorizontal()

BEGIN
  
  -- Insert new record in email table, if it doesn't already exist
 
  
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DOCUMENT_NAME_GROUP')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DOCUMENT_NAME_GROUP','Document Name Group','Document Name Group', 'Dokumentnaamgroep','Nhóm tên tài liệu',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FILE_TYPE')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FILE_TYPE','File Type','File Type', 'Leër tipe','Loại tệp',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='REFERENCE_DOCUMENT')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','REFERENCE_DOCUMENT','Reference Document','Reference Document', 'Reference Document','Tài liệu tham khảo',now(),1);
END IF; 

END $$

-- Execute the stored procedure
CALL V20200106185920__InsertUITranslationForHorizontal() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200106185920__InsertUITranslationForHorizontal $$
 
DELIMITER ;