DELIMITER $$

DROP PROCEDURE IF EXISTS V202001071420__InsertUiMobileApplication $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001071420__InsertUiMobileApplication()

BEGIN
  
   -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='PROFILE_INFORMATION')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','PROFILE_INFORMATION','Profile Information','Profile Information',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='PERSONAL_DETAILS')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
   VALUES ('MOBILE_TRANSLATIONS','PERSONAL_DETAILS','Personal Details','Personal Details',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='DOCUMENTS')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','DOCUMENTS','Documents','Documents',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='DOCUMENT_SUBMISSION_DATE')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','DOCUMENT_SUBMISSION_DATE','Document Submission Date','Document Submission Date',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='DOCUMENT_NAME')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','DOCUMENT_NAME','Document Name','Document Name',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='RETURN_DATE')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','RETURN_DATE','Return Date','Return Date',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='PROGRAM')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','PROGRAM','Program','Program',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='SEAT_TYPE')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','SEAT_TYPE','Seat Type','Seat Type',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='DOCUMENT_REMARKS')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','DOCUMENT_REMARKS','Remarks','Remarks',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='PREDEFINED_DOCUMENTS')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','PREDEFINED_DOCUMENTS','Predefined Documents','Predefined Documents',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='OTHER_DOCUMENT')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','OTHER_DOCUMENT','Others','Others',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MOBILE_TRANSLATIONS' AND keyName='OTHER_INFORMATION')) THEN
    INSERT INTO ui_translation (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('MOBILE_TRANSLATIONS','OTHER_INFORMATION','Other Information','Other Information',now(),1);
END IF;

END $$

-- Execute the stored procedure
CALL V202001071420__InsertUiMobileApplication() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001071420__InsertUiMobileApplication $$
 
DELIMITER ;