DELIMITER $$

DROP PROCEDURE IF EXISTS V202001081601__alterCurrencyExchangeRate $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001081601__alterCurrencyExchangeRate()

BEGIN
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='currency_exchange_rate' 
  AND column_name='toCurrencyId')) THEN
  
	ALTER TABLE `currency_exchange_rate` 
	ADD COLUMN `toCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `validFrom`,
	ADD INDEX `fk_currency_exchange_rate_to_currency_idx` (`toCurrencyId` ASC);
	ALTER TABLE `currency_exchange_rate` 
	ADD CONSTRAINT `fk_currency_exchange_rate_to_currency`
  	FOREIGN KEY (`toCurrencyId`)
  	REFERENCES `currency` (`id`)
  	ON DELETE RESTRICT
  	ON UPDATE RESTRICT;
  END IF;

END $$

-- Execute the stored procedure
CALL V202001081601__alterCurrencyExchangeRate() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001081601__alterCurrencyExchangeRate $$
 
DELIMITER ;