DELIMITER $$

DROP PROCEDURE IF EXISTS V202001081836__CreateSetupExchangeRateTabPrivilege $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001081836__CreateSetupExchangeRateTabPrivilege()

BEGIN
  
   -- Insert new record in privilege table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `privilege` WHERE id = 409 )) THEN
    
	INSERT INTO `privilege` (`id`,`version`,`description`,`displayCode`,`code`,`privilegeName`,`lastUpdatedBy`,`lastUpdate`) 
VALUES ('409','0', 'Setup Exchange Rate', 'Setup Exchange Rate', 'SETUPEXCHANGERATECM', 'Setup Exchange Rate', 1, now());

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `privilege` WHERE id = 410 )) THEN
    
	INSERT INTO `privilege` (`id`,`version`,`description`,`displayCode`,`code`,`privilegeName`,`lastUpdatedBy`,`lastUpdate`) 
VALUES ('410','0', 'Associate Invoice Currency', 'Associate Invoice Currency', 'ASSOCIATEINVOICECM', 'Associate Invoice Currency', 1, now());

  END IF;

END $$

-- Execute the stored procedure
CALL V202001081836__CreateSetupExchangeRateTabPrivilege() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001081836__CreateSetupExchangeRateTabPrivilege $$
 
DELIMITER ;