DELIMITER $$

DROP PROCEDURE IF EXISTS V20200311112533__Create_ReviewParameter $$

CREATE PROCEDURE V20200311112533__Create_ReviewParameter()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='review_parameter')) THEN 

		CREATE TABLE `review_parameter` (
		  `id` bigint(20) NOT NULL AUTO_INCREMENT,
		  `itemCode` varchar(255) NOT NULL,
		  `itemValue` varchar(255) NOT NULL,
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `fk_reviewParameter_updateby` (`lastUpdatedBy`),
		  CONSTRAINT `fk_reviewParameter_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) 
			  ON DELETE NO ACTION 
			  ON UPDATE NO ACTION
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'review_parameter')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1,'review_parameter','REVIEW_PARAMETER','Admissions','COMMON_MASTER',0,0,1,SYSDATE());
			
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'code', 'PARAMETER', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'value', 'DESCRIPTION', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());

	END IF; 

END $$

CALL V20200311112533__Create_ReviewParameter () $$

DROP PROCEDURE IF EXISTS V20200311112533__Create_ReviewParameter $$

DELIMITER ;