DELIMITER $$
DROP PROCEDURE IF EXISTS V20200311175221__Create_createExamEventQuestionDetails $$
CREATE PROCEDURE V20200311175221__Create_createExamEventQuestionDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_event_question_detail' )) THEN 
CREATE TABLE `exam_event_question_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eventId` bigint(20) NOT NULL,
  `courseId` bigint(20) NOT NULL,
  `questionNumber` varchar(255) NOT NULL,
  `maxMarks` double(6,2) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`eventId`,`questionNumber`,`courseId`),
  KEY `fk_exam_event_question_detail_users_idx` (`lastUpdatedBy`),
  KEY `fk_exam_event_question_detail_eval_seq_detail_idx` (`eventId`),
  KEY `fk_exam_event_question_detail_courses_idx` (`courseId`),
  CONSTRAINT `fk_exam_event_question_detail_courses` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_exam_event_question_detail_eval_seq_detail` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_exam_event_question_detail_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20200311175221__Create_createExamEventQuestionDetails () $$ 
DROP PROCEDURE IF EXISTS V20200311175221__Create_createExamEventQuestionDetails $$ 
DELIMITER ;