DELIMITER $$
DROP PROCEDURE IF EXISTS V20200316125302__Create_hostelLeaveServiceRequestDetail $$
CREATE PROCEDURE V20200316125302__Create_hostelLeaveServiceRequestDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_leave_service_request_details')) THEN 
CREATE TABLE `hostel_leave_service_request_details` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `roomAllotmentId` BIGINT(20) NULL,
  `fromDate` DATE NULL,
  `fromTime` TIME NULL,
  `toDate` DATE NULL,
  `toTime` TIME NULL,
  `serviceRequestId` BIGINT(20) NULL,
  `version` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_hsrd_roomallotment_idx` (`roomAllotmentId` ASC),
  INDEX `fs_hsrd_servicerequest_idx` (`serviceRequestId` ASC),
  INDEX `fk_hsrd_lastupdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_hsrd_roomallotment`
    FOREIGN KEY (`roomAllotmentId`)
    REFERENCES `hostel_room_allotment` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fs_hsrd_servicerequest`
    FOREIGN KEY (`serviceRequestId`)
    REFERENCES `service_requests` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_hsrd_lastupdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200316125302__Create_hostelLeaveServiceRequestDetail () $$ 
DROP PROCEDURE IF EXISTS V20200316125302__Create_hostelLeaveServiceRequestDetail $$ 
DELIMITER ;