DELIMITER $$
DROP PROCEDURE IF EXISTS V20200330190021__Create_QP_Student_Details $$
CREATE PROCEDURE V20200330190021__Create_QP_Student_Details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='question_paper_student_details')) THEN 
CREATE TABLE `question_paper_student_details` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `examEventQuestionDetailsId` BIGINT(20) NOT NULL,
  `admissionId` BIGINT(20) NOT NULL,
  `whetherPublish` BIT(1) NULL DEFAULT b'0',
  `obtainedMarks` DOUBLE NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_question_paper_student_details_EEQD_idx` (`examEventQuestionDetailsId` ASC),
  INDEX `fk_question_paper_student_details_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_question_paper_student_details_admissionId_idx` (`admissionId` ASC),
  INDEX `unique_constraint_question_paper_student_details` (`examEventQuestionDetailsId` ASC, `admissionId` ASC),
  CONSTRAINT `fk_examEventQueDetails_id`
    FOREIGN KEY (`examEventQuestionDetailsId`)
    REFERENCES `exam_event_question_detail` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_question_paper_student_details_lastupdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_question_paper_student_details_admissionId`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200330190021__Create_QP_Student_Details () $$ 
DROP PROCEDURE IF EXISTS V20200330190021__Create_QP_Student_Details $$ 
DELIMITER ;