DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402152629__Create_invoice_analytics_view $$
CREATE PROCEDURE V20200402152629__Create_invoice_analytics_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'Invoice_Analytics_View')) THEN 
DROP view `Invoice_Analytics_View`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'invoice_analytics_view')) THEN 
CREATE or REPLACE VIEW `invoice_analytics_view` AS
    select 
        `al`.`academyName` AS `Academy`,
        `al`.`locationName` AS `Location`,
        `al`.`displayName` AS `Academy_Location`,
	`al`.`id` AS `Academy Location Id`,
        `pg`.`groupName` AS `Program_Group`,
        `pc`.`categoryName` AS `CategoryName`,
        `p`.`programSequence` AS `Program_Sequence`,
        `p`.`programName` AS `Program`,
	`p`.`programNameToBePrint` AS `ProgramNameTobePrinted`,
        `iy`.`itemValue` AS `IntakeYear`,
        `b`.`batchName` AS `BatchName`,
        `st`.`seatName` AS `Seat_Type`,
        `u`.`code` AS `Student_Code`,
        `u`.`printName` AS `Student_Name`,
        `bh`.`billNo` AS `Invoice_Number`,
        `bh`.`raiseBillType` AS `Invoice_Type`,
        `bh`.`billingDate` AS `Invoice_Date`,
        `bh`.`dueDate` AS `Due_Date`,
        `c`.`currencyName` AS `CurrencyName`,
        `fh`.`feeHeadName` AS `FeeHeadName`,
        `bfprs`.`feeAmount` AS `InvoiceAmount`,
        if(isnull(`dc`.`discountCode`),
            '-',
            `dc`.`discountCode`) AS `DiscountCode`,
        if(isnull(`bdd`.`discountAmount`),
            '-',
            `bdd`.`discountAmount`) AS `DiscountAmount`,
        `bfprs`.`adjustedAmount` AS `SettledAmount`,
        `bfprs`.`balanceAmount` AS `OutstandingAmoun`
    from
        (((((((((((((((((`bill_fee_plan_rule_stage` `bfprs`
        left join `bill_header` `bh` ON ((`bh`.`id` = `bfprs`.`billId`)))
        left join `users` `u` ON ((`bh`.`studentId` = `u`.`id`)))
        left join `prog_batch_seat_config` `pbsc` ON ((`bh`.`programBatchSeatConfigId` = `pbsc`.`id`)))
        left join `batches` `b` ON ((`b`.`id` = `pbsc`.`programBatchId`)))
        left join `programs` `p` ON ((`p`.`id` = `b`.`programId`)))
        left join `intake_year` `iy` ON ((`b`.`intakeYearId` = `iy`.`id`)))
        left join `currency` `c` ON ((`c`.`id` = `bh`.`currencyId`)))
        left join `fee_stage_head_config` `fshc` ON ((`bfprs`.`feeStageHeadConfigId` = `fshc`.`id`)))
        left join `fee_heads` `fh` ON ((`fh`.`id` = `fshc`.`feeHeadId`)))
        left join `seat_types` `st` ON ((`st`.`id` = `pbsc`.`seatTypeId`)))
        left join `academy_location` `al` ON ((`p`.`academyLocationId` = `al`.`id`)))
        left join `academies` `a` ON ((`al`.`academyId` = `a`.`id`)))
        left join `locations` `l` ON ((`l`.`id` = `al`.`locationId`)))
        left join `program_group` `pg` ON ((`p`.`programGroupId` = `pg`.`id`)))
        left join `program_category` `pc` ON ((`p`.`programCategoryId` = `pc`.`id`)))
        left join `bill_discount_details` `bdd` ON ((`bdd`.`billFeePlanRuleStageId` = `bfprs`.`id`)))
        left join `discount_code` `dc` ON ((`dc`.`id` = `bdd`.`discountCode`)))
    where
        ((`bh`.`billStatus` <> 'CANCELLED')
            and (`bh`.`studentId` is not null)
            and (`bfprs`.`feeAmount` > 0.0));
END IF; 

END $$
CALL V20200402152629__Create_invoice_analytics_view () $$ 
DROP PROCEDURE IF EXISTS V20200402152629__Create_invoice_analytics_view $$ 
DELIMITER ;