DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402161349__Create_fee_rule_association_view $$
CREATE PROCEDURE V20200402161349__Create_fee_rule_association_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'fee_rule_association_view')) THEN 
DROP view `fee_rule_association_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'fee_rule_association_view')) THEN 
CREATE or REPLACE VIEW `fee_rule_association_view` AS
select
        distinct seattype13_.id as 'Seat Type Id',
        program9_.programName as 'Program',
        feeplanrul1_.feeRuleDesc as 'Fee Rule',
        feeplan2_.feePlanName as 'Fee Plan',
        student6_1_.code as 'Student Code',
        admissions8_.admissionDate as 'Admission Date',
        batch10_.batchName as 'Batch',
        programbat11_.programPeriodName as 'Period',
        admissions8_.code as 'Admission Code',
        feeplansta5_.stageName as 'Fee Stage',
        person7_.printName as 'Student Name',
        seattype13_.seatName as 'Seat Type',
        academyloc16_.academyName as 'Academy',
        academyloc16_.locationName as 'Location',
		academyloc16_.locationId as 'Academy Location Id'
    from
        fee_plan_persons_covered this_
    left outer join
        fee_plan_rules feeplanrul1_
            on this_.feePlanRuleId=feeplanrul1_.id
    left outer join
        fee_plan feeplan2_
            on feeplanrul1_.feePlanId=feeplan2_.id
    left outer join
        fee_plan_type feeplantyp3_
            on feeplan2_.feePlanType=feeplantyp3_.id
    left outer join
        fee_plan_rule_stage feeplanrul4_
            on feeplanrul1_.id=feeplanrul4_.feePlanRuleId
    left outer join
        fee_stage_master feeplansta5_
            on feeplanrul4_.stageId=feeplansta5_.id
    left outer join
        students student6_
            on this_.studentId=student6_.userId
    left outer join
        users student6_1_
            on student6_.userId=student6_1_.id
    left outer join
        admission admissions8_
            on student6_.userId=admissions8_.studentId
    left outer join
        academy_location academyloc16_
            on admissions8_.academyLocationId=academyloc16_.id
    left outer join
        batches batch10_
            on admissions8_.batchId=batch10_.id
    left outer join
        intake_year intakeyear15_
            on batch10_.intakeYearId=intakeyear15_.id
    left outer join
        programs program9_
            on admissions8_.programId=program9_.id
    left outer join
        program_category programcat14_
            on program9_.programCategoryId=programcat14_.id
    left outer join
        prog_batch_period_config programbat11_
            on admissions8_.programBatchPeriodConfigId=programbat11_.id
    left outer join
        prog_batch_seat_config programbat12_
            on admissions8_.programBatchSeatConfigId=programbat12_.id
    left outer join
        seat_types seattype13_
            on programbat12_.seatTypeId=seattype13_.id
    left outer join
        persons person7_
            on student6_.personId=person7_.id
    order by
        person7_.printName asc;
END IF; 

END $$
CALL V20200402161349__Create_fee_rule_association_view () $$ 
DROP PROCEDURE IF EXISTS V20200402161349__Create_fee_rule_association_view $$ 
DELIMITER ;