DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402161938__Create_credit_notes_report_view $$
CREATE PROCEDURE V20200402161938__Create_credit_notes_report_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'credit_notes_report_view')) THEN 
DROP view `credit_notes_report_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'credit_notes_report_view')) THEN 
Create or replace VIEW `credit_notes_report_view` AS
    select 
        `al`.`academyName` AS `Brand`,
        `al`.`locationName` AS `Campus`,
        `al`.`displayName` AS `Brand Campus`,
        `al`.`id` AS `Brand Campus Id`,
        `pg`.`groupName` AS `School Phase`,
        `pc`.`categoryName` AS `Grade Category`,
        `p`.`programSequence` AS `Grade Sequence`,
        `p`.`programName` AS `Grade`,
        `iy`.`itemValue` AS `Intake Year`,
        `b`.`batchName` AS `Intake`,
        `st`.`seatName` AS `Seat Type`,
        if(isnull(`u`.`id`),
            'APPLICANT',
            'STUDENT') AS `Discount For`,
        if(isnull(`u`.`code`),
            `a`.`code`,
            `u`.`code`) AS `Student Id`,
        if(isnull(`u`.`printName`),
            `ap`.`printName`,
            `u`.`printName`) AS `Student Name`,
        `dm`.`discountCode` AS `Discount Code`,
        `fh`.`feeHeadName` AS `Discount Fee Head`,
        `asdm`.`discountPercentage` AS `Discount Percentage`,
        `bfprs`.`feeAmount` AS `Discount Amount`,
        `bh`.`billNo` AS `Invoice No.`,
        `bh`.`billingDate` AS `Billing Date`
    from
        ((((((((((((((((`bill_fee_plan_rule_stage` `bfprs`
        left join `fee_stage_head_config` `fshc` ON ((`fshc`.`id` = `bfprs`.`feeStageHeadConfigId`)))
        left join `fee_heads` `fh` ON ((`fshc`.`feeHeadId` = `fh`.`id`)))
        left join `bill_header` `bh` ON ((`bh`.`id` = `bfprs`.`billId`)))
        left join `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `bh`.`programBatchSeatConfigId`)))
        left join `batches` `b` ON ((`b`.`id` = `pbsc`.`programBatchId`)))
        left join `intake_year` `iy` ON ((`iy`.`id` = `b`.`intakeYearId`)))
        left join `programs` `p` ON ((`p`.`id` = `b`.`programId`)))
        left join `program_group` `pg` ON ((`pg`.`id` = `p`.`programGroupId`)))
        left join `program_category` `pc` ON ((`pc`.`id` = `p`.`programCategoryId`)))
        left join `seat_types` `st` ON ((`st`.`id` = `pbsc`.`seatTypeId`)))
        left join `academy_location` `al` ON ((`al`.`id` = `bh`.`academyLocationId`)))
        left join `application` `a` ON ((`a`.`id` = `bh`.`applicantId`)))
        left join `applicant_person` `ap` ON ((`ap`.`id` = `a`.`applicantPersonId`)))
        left join `users` `u` ON ((`u`.`id` = `bh`.`studentId`)))
        left join `applicant_student_discount_master` `asdm` ON ((`asdm`.`id` = `bh`.`studentDiscountMasterId`)))
        left join `discount_master` `dm` ON ((`asdm`.`discountMasterId` = `dm`.`id`)))
    where
        ((`bh`.`studentDiscountMasterId` is not null)
            and (`bh`.`billStatus` <> 'CANCELLED'));

END IF; 

END $$
CALL V20200402161938__Create_credit_notes_report_view () $$ 
DROP PROCEDURE IF EXISTS V20200402161938__Create_credit_notes_report_view $$ 
DELIMITER ;