DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402171418__Create_subject_wise_report_view $$
CREATE PROCEDURE V20200402171418__Create_subject_wise_report_view()
BEGIN

	IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
		   WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'subject_wise_report_view')) THEN 
	DROP view `subject_wise_report_view`;
	END IF; 


	IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
		   WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'subject_wise_report_view')) THEN
CREATE OR REPLACE VIEW `subject_wise_report_view` AS
    select distinct
        `al`.`displayName` AS `Brand`,
        `al`.`locationName` AS `Campus`,
        `al`.`id` AS `Academy_Location_Id`,
        `pg`.`groupName` AS `School Phase`,
        `prgm`.`programNameToBePrint` AS `Grade`,
        `pc`.`categoryName` AS `Grade Category`,
        `batch`.`printName` AS `Intake`,
        `period`.`printName` AS `Period`,
        `person`.`printName` AS `Student Name`,
        `usr`.`code` AS `Student Id`,
        `course`.`nameToBePrinted` AS `Subject`,
        `cv`.`courseVariantCode` AS `Subject Variant`,
        `planRank`.`marksOrGrade` AS `Marking Type`,
        `planRank`.`marksObtainedFrom` AS `Max Marks`,
        `planRank`.`minMarksOrGrade` AS `Min Marks`,
        `course`.`courseCredits` AS `Subject Credits`,
        `fac`.`printName` AS `Teacher`,
        `cc`.`categoryName` AS `Subject Category`,
        `planRank`.`effectiveMarks` AS `Subject Level Marks`,
        `planRank`.`grade` AS `Subject Grade`,
        `avrg`.`marks` AS `Grade Average`,
        `planRank`.`effectiveMarks` AS `Percentage`,
        `planRank`.`courseRank` AS `Subject Rank`,
        `planRank`.`status` AS `Result Status`
    from
        ((((((((((((((((((`evaluation_plan_rank` `planRank`
        join `admission` ON ((`admission`.`id` = `planRank`.`admissionId`)))
        join `academy_location` `al` ON ((`admission`.`academyLocationId` = `al`.`id`)))
        join `students` `stu` ON ((`admission`.`studentId` = `stu`.`userId`)))
        join `users` `usr` ON ((`stu`.`userId` = `usr`.`id`)))
        join `persons` `person` ON ((`stu`.`personId` = `person`.`id`)))
        left join `course_variants` `cv` ON ((`cv`.`id` = `planRank`.`courseVariantId`)))
        left join `courses` `course` ON ((`course`.`id` = `cv`.`courseId`)))
        join `prog_batch_period_config` `period` ON ((`period`.`id` = `planRank`.`periodId`)))
        join `batches` `batch` ON ((`batch`.`id` = `period`.`programBatchId`)))
        join `programs` `prgm` ON ((`prgm`.`id` = `batch`.`programId`)))
        left join `program_group` `pg` ON ((`pg`.`id` = `prgm`.`programGroupId`)))
        left join `program_category` `pc` ON ((`pc`.`id` = `prgm`.`programCategoryId`)))
        left join `course_category` `cc` ON ((`cc`.`id` = `course`.`courseCategoryId`)))
        join `sections` `section` ON ((`section`.`id` = `planRank`.`sectionId`)))
        left join `program_batch_course_param` `param` ON ((`param`.`courseVarientId` = `cv`.`id`)))
        left join `prog_batch_course_faculty` `pbcf` ON ((`pbcf`.`progBatchCourseParamId` = `param`.`id`)))
        left join `users` `fac` ON ((`fac`.`id` = `pbcf`.`facultyId`)))
        left join `exam_course_grade_average` `avrg` ON (((`avrg`.`courseId` = `course`.`id`)
            and (`planRank`.`evaluationPlanId` = `avrg`.`planId`)
            and (`avrg`.`periodId` = `planRank`.`periodId`))));

END IF; 

END $$
CALL V20200402171418__Create_subject_wise_report_view () $$ 
DROP PROCEDURE IF EXISTS V20200402171418__Create_subject_wise_report_view $$ 
DELIMITER ;