DELIMITER $$
DROP PROCEDURE IF EXISTS V20200408114050__Create_dataRequirementSetup $$
CREATE PROCEDURE V20200408114050__Create_dataRequirementSetup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='data_requirement_setup')) THEN 
CREATE TABLE data_requirement_setup (
    id BIGINT(20) AUTO_INCREMENT primary key,
    applicant_portal_setup_id BIGINT(20) DEFAULT NULL,
    applicant_portal_module_id BIGINT(20) DEFAULT NULL,
    exam_pass VARCHAR(50) DEFAULT NULL,
    maximum_entry BIGINT(20) DEFAULT NULL,
    minimum_entry BIGINT(20) DEFAULT NULL,
    is_visible TINYINT(1) DEFAULT NULL,
    is_mandatory TINYINT(1) DEFAULT NULL,
    sequence BIGINT(20) DEFAULT NULL,
    lastUpdate  TIMESTAMP DEFAULT  CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
    FOREIGN KEY (applicant_portal_setup_id)
        REFERENCES applicant_portal_setup (id),
    FOREIGN KEY (applicant_portal_module_id)
        REFERENCES applicant_portal_modules (id),
    FOREIGN KEY (lastUpdatedBy)
        REFERENCES users (id)
);
END IF; 

END $$
CALL V20200408114050__Create_dataRequirementSetup() $$ 
DROP PROCEDURE IF EXISTS V20200408114050__Create_dataRequirementSetup $$ 
DELIMITER ;