DELIMITER $$
DROP PROCEDURE IF EXISTS V20200408142440__Insert_addReportTemplate $$
CREATE PROCEDURE V20200408142440__Insert_addReportTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode`='INIFD_HALL_TICKET')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ( '8', 'INIFD_HALL_TICKET', 'INIFD Hall Ticket', 'INIFD_HALL_TICKET.png', 'CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'INIFD_HALL_TICKET.jasper', 'AcademiaLogo.png');

IF EXISTS ((SELECT * FROM `report_template` WHERE `templateCode`='INIFD_HALL_TICKET')) THEN 
set @translationId = (SELECT `id` FROM `report_template` WHERE `templateCode`='INIFD_HALL_TICKET');
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@translationId, 'TRANS_TEXT', 'HALL TICKET', NULL, NOW()),
(@translationId, 'TRANS_IDNO', 'ID No.:', NULL, NOW()),
(@translationId, 'TRANS_STUDENT_NAME', 'Student Name:', NULL, NOW()),
(@translationId, 'TRANS_COURSE', 'Course Code', NULL, NOW()),
(@translationId, 'TRANS_COURSE_NAME', 'Course Name', NULL, NOW()),
(@translationId, 'TRANS_EXAM_DATE', 'Exam Date & Day', NULL, NOW()),
(@translationId, 'TRANS_EXAM_TIME', 'Exam Time', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION', 'Instruction to Students:', NULL, NOW()),
(@translationId, 'TRANS_TEXT_AREA', 
'1. Students are requested to report in the examination hall at least 15 minutes before the commencement of the examination.
2. Kindly bring this Hall Ticket to the exam hall every day.
3. Mobile phones are not allowed inside the examination hall.', NULL, NOW());
END IF; 

END IF; 

END $$
CALL V20200408142440__Insert_addReportTemplate() $$
DROP PROCEDURE IF EXISTS V20200408142440__Insert_addReportTemplate $$
DELIMITER ;