DELIMITER $$
DROP PROCEDURE IF EXISTS V20200413141842__Insert_DFRforTopicForm $$
CREATE PROCEDURE V20200413141842__Insert_DFRforTopicForm()
BEGIN

SET sql_safe_updates=0;

IF EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'topicform')) THEN 
delete FROM form_field_helptext_lang_translation where formFieldDisplaySettingsId in (select form_field_display_settings.id FROM form_field_display_settings inner join form_field_info on form_field_info.id=form_field_display_settings.formFieldInfoId and form_field_info.formAliasName = 'topicform');

delete FROM form_field_display_settings where formFieldInfoId in (select id FROM `form_field_info` WHERE formAliasName = 'topicform');

delete FROM `form_field_info` WHERE formAliasName = 'topicform';
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'topicform' and formFieldId = 'topicSequence')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('topicform','topicSequence','topicSequence','numberfield',1,1,'1',1, NOW() ,'Topic Sequence','','Topic Form','Create, Edit, and View','Topic Sequence',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'topicform' and formFieldId = 'topicName')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('topicform','topicName','topicName','textfield',1,1,null,1, NOW() ,'Topic Name','','Topic Form','Create, Edit, and View','Topic Name',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'topicform' and formFieldId = 'noOfSessionsId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('topicform','noOfSessions','noOfSessionsId','numberfield',0,0,'1',1, NOW() ,'No. of Sessions','','Topic Form','Create, Edit, and View','No. of Sessions',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'topicform' and formFieldId = 'topicDepth')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('topicform','topicDepth','topicDepth','customcombobox',0,0,'1',1, NOW() ,'Topic in Depth','','Topic Form','Create, Edit, and View','Topic in Depth',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'topicform' and formFieldId = 'topicDescription')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('topicform','topicDescription','topicDescription','textarea',0,0,null,1, NOW() ,'Topic Description','','Topic Form','Create, Edit, and View','Topic Description',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'topicform' and formFieldId = 'topicMinutes')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('topicform','topicMinutes','topicMinutes','numberfield',0,0,'60',1, NOW() ,'Topic Minutes','','Topic Form','Create, Edit, and View','Topic Minutes',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'topicform' and formFieldId = 'whetherCompulsoryId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('topicform','whetherCompulsoryId','whetherCompulsoryId','radiogroup',0,0,'1',1, NOW() ,'Topic Is Compulsory','','Topic Form','Create, Edit, and View','Topic Is Compulsory',0);
END IF; 

SET sql_safe_updates=1;

END $$
CALL V20200413141842__Insert_DFRforTopicForm() $$
DROP PROCEDURE IF EXISTS V20200413141842__Insert_DFRforTopicForm $$
DELIMITER ;