DELIMITER $$
DROP PROCEDURE IF EXISTS V20200415100339__Insert_DataGridStudentAttendanceList $$
CREATE PROCEDURE V20200415100339__Insert_DataGridStudentAttendanceList()
BEGIN

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="STUDENT_ATTENDANCE_LIST" )) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','STUDENT_ATTENDANCE_LIST','Student Attendance List','Student Attendance List',now(),1);
END IF;

IF NOT EXISTS ((select * from data_grid where gridName="Academia.view.attendance.StudentAttendanceGrid" and portalId=1)) THEN 
INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
('Academia.view.attendance.StudentAttendanceGrid',1,
'[{"id":null,"columnName":"SNO","dataIndex":"","columnVisibility":"SHOW","sequence":1,"mandatory":true},
{"id":null,"columnName":"ADMISSION_CODE","dataIndex":"admissionCode","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"STUDENT_CODE","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"STUDENT_NAME","dataIndex":"studentName","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"STUDENT_FIRST_NAME","dataIndex":"firstName","columnVisibility":"HIDE","sequence":5,"mandatory":false},
{"id":null,"columnName":"STUDENT_MIDDLE_NAME","dataIndex":"middleName","columnVisibility":"HIDE","sequence":6,"mandatory":false},
{"id":null,"columnName":"STUDENT_LAST_NAME","dataIndex":"lastName","columnVisibility":"SHOW","sequence":7,"mandatory":false},
{"id":null,"columnName":"PRESENT","dataIndex":"present","columnVisibility":"SHOW","sequence":8,"mandatory":true},
{"id":null,"columnName":"ABSENT","dataIndex":"absent","columnVisibility":"SHOW","sequence":9,"mandatory":true},
{"id":null,"columnName":"OTHERS","dataIndex":"attendanceStatus","columnVisibility":"SHOW","sequence":10,"mandatory":true},
{"id":null,"columnName":"REMARKS","dataIndex":"comment","columnVisibility":"SHOW","sequence":11,"mandatory":false}]',now(),1);
END IF; 

END $$
CALL V20200415100339__Insert_DataGridStudentAttendanceList() $$
DROP PROCEDURE IF EXISTS V20200415100339__Insert_DataGridStudentAttendanceList $$
DELIMITER ;
