DELIMITER $$

DROP PROCEDURE IF EXISTS V20200416172228_Insert_addmissionDetailUITrns $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200416172228_Insert_addmissionDetailUITrns()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='FIELD_OF_INTEREST')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','FIELD_OF_INTEREST','Field of Interest','Field of Interest',now(),1);
 END IF;

 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='ENQ_ADMISSION_DETAILS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','ENQ_ADMISSION_DETAILS','Enquiry Admission Details','Enquiry Admission Details',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='ACADEMIC_INTAKE')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','ACADEMIC_INTAKE','Intake','Intake',now(),1);
 END IF;
 
END $$  

-- Execute the stored procedure
CALL V20200416172228_Insert_addmissionDetailUITrns() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200416172228_Insert_addmissionDetailUITrns $$
 
DELIMITER ;