DELIMITER $$
DROP PROCEDURE IF EXISTS V20200509170751__Insert_AuReceiptReportStudent $$
CREATE PROCEDURE V20200509170751__Insert_AuReceiptReportStudent()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'AUM_RECEIPT_WITH_SETTLEMENT_STUDENT')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('4', 'AUM_RECEIPT_WITH_SETTLEMENT_STUDENT', 'AU Multicurrency Receipt with settlement - Triplicate (Students)', 'SettlementTriplicateCollege.png', 'CommonReport_LandScape_pageNo_LeftCenterRight.jasper', 'All', '1', 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', '0', '0', 'AuReceiptReportStudent.jasper', 'AcademiaLogo.png');
set @d1ReceiptSettleStudent = (select max(id) from report_template where templateCode ='AUM_RECEIPT_WITH_SETTLEMENT_STUDENT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@d1ReceiptSettleStudent , 'TRANS_RECEIPTNO', 'Receipt No.', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_DATE', 'Date', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_RECEIVED_FROM', 'Received From', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_FATHER_NAME', 'Father Name', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_ID', 'Id', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_ACADEMY_NAME', 'Academy Name', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_PROGRAM_NAME', 'Program Name', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_PROCESSED_BY', 'Processed By', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_REMARK', 'Remark', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_SR_NO', 'Sr. No.', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_PARTICULAR', 'Particular', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@d1ReceiptSettleStudent , 'TRANS_BANK_NAME', 'Bank Name', '1', NOW());


END IF; 

END $$
CALL V20200509170751__Insert_AuReceiptReportStudent() $$
DROP PROCEDURE IF EXISTS V20200509170751__Insert_AuReceiptReportStudent $$
DELIMITER ;