DELIMITER $$
DROP PROCEDURE IF EXISTS V20200527124318__Create_Program_Document $$
CREATE PROCEDURE V20200527124318__Create_Program_Document()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_documents')) THEN 
CREATE TABLE `program_documents` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `documentId` BIGINT(20) NOT NULL,
  `programId` BIGINT(20) NOT NULL,
  `fileType` VARCHAR(100) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_program_documents_1_idx` (`programId` ASC),
  INDEX `fk_program_documents_2_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_program_documents_3_idx` (`documentId` ASC),
  CONSTRAINT `fk_program_documents_1`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_documents_2`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_documents_3`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200527124318__Create_Program_Document () $$ 
DROP PROCEDURE IF EXISTS V20200527124318__Create_Program_Document $$ 
DELIMITER ;