DELIMITER $$
DROP PROCEDURE IF EXISTS V20200608120451__Create_outcomeCutoffView $$
CREATE PROCEDURE V20200608120451__Create_outcomeCutoffView()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='outcome_cutoff_view')) THEN 
CREATE 
   OR REPLACE
VIEW `outcome_cutoff_view` AS

	SELECT
    academyLoc.id AS academy_location_id,
    academyLoc.academyCode AS academy_code,
    academyLoc.displayName AS academy_display_name,
    academy.academyName AS academy,
    academyLoc.locationName AS location_name,
    intakeYears.itemValue AS intake_year,
    academicT.itemValue AS academic_term,
    programGroup.groupName AS program_group,
    program.programName AS program,
    program.programShortName AS program_short_name,
    program.programNameToBePrint AS program_name_to_be_print,
    batch.batchName AS batch_name,
    progBatchPeriodConfig.printName AS period,
    progBatchPeriodConfig.id AS period_id,
    course.nameToBePrinted AS course,
    course.courseShortName AS course_short_name,
    course.courseCode AS course_code,
    courseVarient.courseVariantDescription AS course_variant,
    section.sectionCode AS section_code,
    section.alternateName AS section_name,
    evaluationPlan.printNameInMarksheet AS assessment_scheme,
    evaluationPlanLevelTwo.levelName AS assessment_level,
    evalSeqDetail.detailSequenceNumber AS event,
    questionMapping.cutOffPercentage AS 'student_co_attained_cutoff_percentage',
	rule.name as 'attainment_rule_name',
    levels.name as 'attainment_level_name',
    levels.levelValue as 'attainment_level_value',
    levels.percentageRangeFrom as 'percentage_range_from',
	levels.percentageRangeTo as 'percentage_range_to'
FROM
    exam_event_question_detail AS question
        INNER JOIN
    event_question_detail_mapping AS questionMapping ON questionMapping.questionDetailsId = question.id
     INNER JOIN
    attainment_rule AS rule ON questionMapping.attainmentRuleId = rule.id
     INNER JOIN
    attainment_level AS levels ON levels.attainmentRuleId = rule.id
INNER JOIN
    obe_correlation_level AS correlation ON questionMapping.correlationId = correlation.id
        INNER JOIN
    courses AS course ON course.id = question.courseId
        INNER JOIN
    eval_seq_detail evalSeqDetail ON question.eventId = evalSeqDetail.id
        INNER JOIN
    evaluation_sequence evaluationSequence ON evalSeqDetail.evalSequenceId = evaluationSequence.id
        INNER JOIN
    evaluation_plan_level_two evaluationPlanLevelTwo ON evaluationSequence.evalPlanLevelTwoId = evaluationPlanLevelTwo.id
        INNER JOIN
    evaluation_plan_level_one evaluationPlanLevelOne ON evaluationPlanLevelTwo.evalPlanLevelOneId = evaluationPlanLevelOne.id
        INNER JOIN
    evaluation_plan evaluationPlan ON evaluationPlanLevelOne.evaluationPlanId = evaluationPlan.id
        INNER JOIN
    program_batch_course_param programBatchCourseParam ON course.id = programBatchCourseParam.courseId
        INNER JOIN
    course_variants courseVarient ON programBatchCourseParam.courseVarientId = courseVarient.id
        INNER JOIN
    prog_batch_course_details progBatchCourseDetails ON courseVarient.id = progBatchCourseDetails.courseVarientId
        INNER JOIN
    prog_batch_period_config progBatchPeriodConfig ON progBatchCourseDetails.programBatchPeriodConfigId = progBatchPeriodConfig.id
        INNER JOIN
    academic_term academicT ON progBatchPeriodConfig.academicTermId = academicT.id
        LEFT OUTER JOIN
    batches batch ON progBatchPeriodConfig.programBatchId = batch.id
        LEFT OUTER JOIN
    intake_year intakeYears ON batch.intakeYearId = intakeYears.id
        LEFT OUTER JOIN
    programs program ON batch.programId = program.id
        LEFT OUTER JOIN
    academy_location academyLoc ON program.academyLocationId = academyLoc.id
        LEFT OUTER JOIN
    academies academy ON academyLoc.academyId = academy.id
        LEFT OUTER JOIN
    program_group programGroup ON program.programGroupId = programGroup.id
        LEFT OUTER JOIN
    sections section ON programBatchCourseParam.sectionId = section.id
        LEFT OUTER JOIN
    question_paper_student_details paper ON paper.examEventQuestionDetailsId = question.id
GROUP BY levels.id;
END IF; 

END $$
CALL V20200608120451__Create_outcomeCutoffView () $$ 
DROP PROCEDURE IF EXISTS V20200608120451__Create_outcomeCutoffView $$ 
DELIMITER ;