DELIMITER $$
DROP PROCEDURE IF EXISTS V20200624150246__Insert_addReportTemplate $$
CREATE PROCEDURE V20200624150246__Insert_addReportTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM report_template WHERE templateCode='LEARNING_TARGET_PLAN_REPORT')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'LEARNING_TARGET_PLAN_REPORT', 'Individual Learning Plan', 'LEARNING_TARGET_PLAN_REPORT.png', 'CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'LEARNING_TARGET_PLAN_REPORT.jasper', 'AcademiaLogo.png');

END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE `templateCode`='LEARNING_TARGET_PLAN_REPORT')) THEN 
set @translationId = (SELECT `id` FROM `report_template` WHERE `templateCode`='LEARNING_TARGET_PLAN_REPORT');

INSERT INTO `report_template_translations` ( `reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdate`) 
VALUES (@translationId, 'TRANS_STUDENT_NAME', 'Student Name:', NOW()),
(@translationId, 'TRANS_STUDENT_ID', 'Student ID:', NOW()),
(@translationId, 'TRANS_PROGRAM', 'Program:',  NOW()),
(@translationId, 'TRANS_PERIOD', 'Period:',  NOW()),
(@translationId, 'TRANS_SECTION', 'Section:',  NOW()),
(@translationId, 'TRANS_FACULTY', 'Faculty:',  NOW()),
(@translationId, 'TRANS_REVIEW_DATE', 'Review Date:', NOW()),
(@translationId, 'TRANS_NEXT_REVIEW_DATE', 'Next Review Date:',  NOW()),
(@translationId, 'TRANS_COURSE_NO', 'Course No.',  NOW()),
(@translationId, 'TRANS_COURSE_CODE', 'Course Code / Name',  NOW()),
(@translationId, 'TRANS_TARGET_GRADE', 'Target Grade / Marks',  NOW()),
(@translationId, 'TRANS_GRADE_ACHIEVED', 'Garde / Marks Achieved',  NOW()),
(@translationId, 'TRANS_TRAGET_ATTENDANCE', 'Target Attendance (%)', NOW()),
(@translationId, 'TRANS_ATTENDANCE_ACHIEVED', 'Attendance Achieved (%)', NOW()),
(@translationId, 'TRANS_FACULTY_COMMENT', 'Faculty Comment:', NOW()),
(@translationId, 'TRANS_STUDENT_COMMENT', 'Student Comment (if any):', NOW()),
(@translationId, 'TRANS_STUDENT_SIGNATURE', 'Student\'s Signature:', NOW()),
(@translationId, 'TRANS_FACULTY_SIGNATURE', 'Faculty Signature:', NOW()),
(@translationId, 'TRANS_PROGRAM_MANAGER_SIGNATURE', 'Program Manager\'s Signature:', NOW()),
(@translationId, 'TRANS_DATE', 'Date:', NOW()),
(@translationId, 'TRANS_STATIC_TEXT', 'INDIVIDUAL LERANING PLAN', NOW()), 
(@translationId, 'TRANS_NOTE', 'The individual learning plan is structured to assist the students to analyse and plan their progression in various aspects of their study programme.', NOW());


END IF; 

END $$
CALL V20200624150246__Insert_addReportTemplate() $$
DROP PROCEDURE IF EXISTS V20200624150246__Insert_addReportTemplate $$
DELIMITER ;