DELIMITER $$
DROP PROCEDURE IF EXISTS V20200701145250__Create_HRLeaveCreditSettingLocation $$
CREATE PROCEDURE V20200701145250__Create_HRLeaveCreditSettingLocation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hr_leave_credit_setting_location')) THEN 
CREATE TABLE `hr_leave_credit_setting_location`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`hrLeaveCreditSettingId` BIGINT(20) NOT NULL,
	`academyLocationId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY `unique_hrlcsl_al_index` (`hrLeaveCreditSettingId`,`academyLocationId`),
	INDEX `fk_hr_leave_credit_setting_location_1_idx` (`hrLeaveCreditSettingId` ASC),
    INDEX `fk_hr_leave_credit_setting_location_2_idx` (`academyLocationId` ASC),
    CONSTRAINT `fk_hr_leave_credit_setting_location_hrlcsId`
	FOREIGN KEY (`hrLeaveCreditSettingId`) REFERENCES `hr_leave_credit_setting`(`id`)
	ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_hr_leave_credit_setting_location_alId`
	FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`)
	ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_hr_leave_credit_setting_location_usrId`
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
	ON DELETE NO ACTION
    ON UPDATE NO ACTION
);
END IF; 

END $$
CALL V20200701145250__Create_HRLeaveCreditSettingLocation () $$ 
DROP PROCEDURE IF EXISTS V20200701145250__Create_HRLeaveCreditSettingLocation $$ 
DELIMITER ;